/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.oss.credential.policy;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.gravitino.oss.credential.policy.Condition;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Statement {
    @JsonProperty(value="Effect")
    private String effect;
    @JsonProperty(value="Action")
    private List<String> actions;
    @JsonProperty(value="Resource")
    private List<String> resources;
    @JsonProperty(value="Condition")
    private Condition condition;

    private Statement(Builder builder) {
        this.effect = builder.effect;
        this.actions = builder.actions;
        this.resources = builder.resources;
        this.condition = builder.condition;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEffect() {
        return this.effect;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public static class Builder {
        private String effect;
        private List<String> actions = new ArrayList<String>();
        private List<String> resources = new ArrayList<String>();
        private Condition condition;

        public Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        public Builder addAction(String action) {
            this.actions.add(action);
            return this;
        }

        public Builder addResource(String resource) {
            this.resources.add(resource);
            return this;
        }

        public Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public Statement build() {
            return new Statement(this);
        }
    }
}

