/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.Bound;
import org.apache.iceberg.expressions.BoundExtract;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.BoundTransform;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.VariantExpressionUtil;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.NaNUtil;
import org.apache.iceberg.variants.Variant;
import org.apache.iceberg.variants.VariantObject;

public class InclusiveMetricsEvaluator {
    private static final int IN_PREDICATE_LIMIT = 200;
    private final Expression expr;
    private static final boolean ROWS_MIGHT_MATCH = true;
    private static final boolean ROWS_CANNOT_MATCH = false;

    public InclusiveMetricsEvaluator(Schema schema, Expression unbound) {
        this(schema, unbound, true);
    }

    public InclusiveMetricsEvaluator(Schema schema, Expression unbound, boolean caseSensitive) {
        Types.StructType struct = schema.asStruct();
        this.expr = Binder.bind(struct, Expressions.rewriteNot(unbound), caseSensitive);
    }

    public boolean eval(ContentFile<?> file) {
        return new MetricsEvalVisitor().eval(file);
    }

    private static VariantObject parseBounds(ByteBuffer buffer) {
        return Variant.from(buffer).value().asObject();
    }

    private class MetricsEvalVisitor
    extends ExpressionVisitors.BoundVisitor<Boolean> {
        private Map<Integer, Long> valueCounts = null;
        private Map<Integer, Long> nullCounts = null;
        private Map<Integer, Long> nanCounts = null;
        private Map<Integer, ByteBuffer> lowerBounds = null;
        private Map<Integer, ByteBuffer> upperBounds = null;

        private MetricsEvalVisitor() {
        }

        private boolean eval(ContentFile<?> file) {
            if (file.recordCount() == 0L) {
                return false;
            }
            if (file.recordCount() < 0L) {
                return true;
            }
            this.valueCounts = file.valueCounts();
            this.nullCounts = file.nullValueCounts();
            this.nanCounts = file.nanValueCounts();
            this.lowerBounds = file.lowerBounds();
            this.upperBounds = file.upperBounds();
            return ExpressionVisitors.visitEvaluator(InclusiveMetricsEvaluator.this.expr, this);
        }

        @Override
        public Boolean alwaysTrue() {
            return true;
        }

        @Override
        public Boolean alwaysFalse() {
            return false;
        }

        @Override
        public Boolean not(Boolean result) {
            return result == false;
        }

        @Override
        public Boolean and(Boolean leftResult, Boolean rightResult) {
            return leftResult != false && rightResult != false;
        }

        @Override
        public Boolean or(Boolean leftResult, Boolean rightResult) {
            return leftResult != false || rightResult != false;
        }

        @Override
        public <T> Boolean isNull(Bound<T> term) {
            int id;
            if (this.isNonNullPreserving(term) && !this.mayContainNull(id = term.ref().fieldId())) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean notNull(Bound<T> term) {
            int id = term.ref().fieldId();
            if (this.containsNullsOnly(id)) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean isNaN(Bound<T> term) {
            int id = term.ref().fieldId();
            if (this.containsNullsOnly(id)) {
                return false;
            }
            if (!(term instanceof BoundReference)) {
                return true;
            }
            if (this.nanCounts != null && this.nanCounts.containsKey(id) && this.nanCounts.get(id) == 0L) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean notNaN(Bound<T> term) {
            if (!(term instanceof BoundReference)) {
                return true;
            }
            int id = term.ref().fieldId();
            if (this.containsNaNsOnly(id)) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean lt(Bound<T> term, Literal<T> lit) {
            int id = term.ref().fieldId();
            if (this.containsNullsOnly(id) || this.containsNaNsOnly(id)) {
                return false;
            }
            T lower = this.lowerBound(term);
            if (null == lower || NaNUtil.isNaN(lower)) {
                return true;
            }
            int cmp = lit.comparator().compare(lower, lit.value());
            if (cmp >= 0) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean ltEq(Bound<T> term, Literal<T> lit) {
            int id = term.ref().fieldId();
            if (this.containsNullsOnly(id) || this.containsNaNsOnly(id)) {
                return false;
            }
            T lower = this.lowerBound(term);
            if (null == lower || NaNUtil.isNaN(lower)) {
                return true;
            }
            int cmp = lit.comparator().compare(lower, lit.value());
            if (cmp > 0) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean gt(Bound<T> term, Literal<T> lit) {
            int id = term.ref().fieldId();
            if (this.containsNullsOnly(id) || this.containsNaNsOnly(id)) {
                return false;
            }
            T upper = this.upperBound(term);
            if (null == upper) {
                return true;
            }
            int cmp = lit.comparator().compare(upper, lit.value());
            if (cmp <= 0) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean gtEq(Bound<T> term, Literal<T> lit) {
            int id = term.ref().fieldId();
            if (this.containsNullsOnly(id) || this.containsNaNsOnly(id)) {
                return false;
            }
            T upper = this.upperBound(term);
            if (null == upper) {
                return true;
            }
            int cmp = lit.comparator().compare(upper, lit.value());
            if (cmp < 0) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean eq(Bound<T> term, Literal<T> lit) {
            int cmp;
            int id = term.ref().fieldId();
            if (this.containsNullsOnly(id) || this.containsNaNsOnly(id)) {
                return false;
            }
            T lower = this.lowerBound(term);
            if (lower != null && !NaNUtil.isNaN(lower) && (cmp = lit.comparator().compare(lower, lit.value())) > 0) {
                return false;
            }
            T upper = this.upperBound(term);
            if (null == upper) {
                return true;
            }
            int cmp2 = lit.comparator().compare(upper, lit.value());
            if (cmp2 < 0) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean notEq(Bound<T> term, Literal<T> lit) {
            return true;
        }

        @Override
        public <T> Boolean in(Bound<T> term, Set<T> literalSet) {
            int id = term.ref().fieldId();
            if (this.containsNullsOnly(id) || this.containsNaNsOnly(id)) {
                return false;
            }
            Collection<Object> literals = literalSet;
            if (literals.size() > 200) {
                return true;
            }
            Object lower = this.lowerBound(term);
            if (null == lower || NaNUtil.isNaN(lower)) {
                return true;
            }
            if ((literals = (Collection)literals.stream().filter(v -> ((BoundTerm)term).comparator().compare(lower, v) <= 0).collect(Collectors.toList())).isEmpty()) {
                return false;
            }
            Object upper = this.upperBound(term);
            if (null == upper) {
                return true;
            }
            if ((literals = (Collection)literals.stream().filter(v -> ((BoundTerm)term).comparator().compare(upper, v) >= 0).collect(Collectors.toList())).isEmpty()) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean notIn(Bound<T> term, Set<T> literalSet) {
            return true;
        }

        @Override
        public <T> Boolean startsWith(Bound<T> term, Literal<T> lit) {
            if (term instanceof BoundTransform && !((BoundTransform)term).transform().isIdentity()) {
                return true;
            }
            int id = term.ref().fieldId();
            if (this.containsNullsOnly(id)) {
                return false;
            }
            String prefix = (String)lit.value();
            Comparator<CharSequence> comparator = Comparators.charSequences();
            CharSequence lower = (CharSequence)this.lowerBound(term);
            if (null == lower) {
                return true;
            }
            int length = Math.min(prefix.length(), lower.length());
            int cmp = comparator.compare(lower.subSequence(0, length), prefix);
            if (cmp > 0) {
                return false;
            }
            CharSequence upper = (CharSequence)this.upperBound(term);
            if (null == upper) {
                return true;
            }
            length = Math.min(prefix.length(), upper.length());
            cmp = comparator.compare(upper.subSequence(0, length), prefix);
            if (cmp < 0) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean notStartsWith(Bound<T> term, Literal<T> lit) {
            int id = term.ref().fieldId();
            if (this.mayContainNull(id)) {
                return true;
            }
            String prefix = (String)lit.value();
            Comparator<CharSequence> comparator = Comparators.charSequences();
            CharSequence lower = (CharSequence)this.lowerBound(term);
            CharSequence upper = (CharSequence)this.upperBound(term);
            if (null == lower || null == upper) {
                return true;
            }
            if (lower.length() < prefix.length()) {
                return true;
            }
            int cmp = comparator.compare(lower.subSequence(0, prefix.length()), prefix);
            if (cmp == 0) {
                if (upper.length() < prefix.length()) {
                    return true;
                }
                cmp = comparator.compare(upper.subSequence(0, prefix.length()), prefix);
                if (cmp == 0) {
                    return false;
                }
            }
            return true;
        }

        private boolean mayContainNull(Integer id) {
            return this.nullCounts == null || !this.nullCounts.containsKey(id) || this.nullCounts.get(id) != 0L;
        }

        private boolean containsNullsOnly(Integer id) {
            return this.valueCounts != null && this.valueCounts.containsKey(id) && this.nullCounts != null && this.nullCounts.containsKey(id) && this.valueCounts.get(id) - this.nullCounts.get(id) == 0L;
        }

        private boolean containsNaNsOnly(Integer id) {
            return this.nanCounts != null && this.nanCounts.containsKey(id) && this.valueCounts != null && this.nanCounts.get(id).equals(this.valueCounts.get(id));
        }

        private <T> T lowerBound(Bound<T> term) {
            if (term instanceof BoundReference) {
                return this.parseLowerBound((BoundReference)term);
            }
            if (term instanceof BoundTransform) {
                return this.transformLowerBound((BoundTransform)term);
            }
            if (term instanceof BoundExtract) {
                return this.extractLowerBound((BoundExtract)term);
            }
            return null;
        }

        private <T> T upperBound(Bound<T> term) {
            if (term instanceof BoundReference) {
                return this.parseUpperBound((BoundReference)term);
            }
            if (term instanceof BoundTransform) {
                return this.transformUpperBound((BoundTransform)term);
            }
            if (term instanceof BoundExtract) {
                return this.extractUpperBound((BoundExtract)term);
            }
            return null;
        }

        private <T> T parseLowerBound(BoundReference<T> ref) {
            int id = ref.fieldId();
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id)) {
                return Conversions.fromByteBuffer(ref.ref().type(), this.lowerBounds.get(id));
            }
            return null;
        }

        private <T> T parseUpperBound(BoundReference<T> ref) {
            int id = ref.fieldId();
            if (this.upperBounds != null && this.upperBounds.containsKey(id)) {
                return Conversions.fromByteBuffer(ref.ref().type(), this.upperBounds.get(id));
            }
            return null;
        }

        private <S, T> T transformLowerBound(BoundTransform<S, T> boundTransform) {
            Transform<S, T> transform = boundTransform.transform();
            if (transform.preservesOrder()) {
                S lower = this.parseLowerBound(boundTransform.ref());
                return (T)boundTransform.transform().bind(boundTransform.ref().type()).apply(lower);
            }
            return null;
        }

        private <S, T> T transformUpperBound(BoundTransform<S, T> boundTransform) {
            Transform<S, T> transform = boundTransform.transform();
            if (transform.preservesOrder()) {
                S upper = this.parseUpperBound(boundTransform.ref());
                return (T)boundTransform.transform().bind(boundTransform.ref().type()).apply(upper);
            }
            return null;
        }

        private <T> T extractLowerBound(BoundExtract<T> bound) {
            int id = bound.ref().fieldId();
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id)) {
                VariantObject fieldLowerBounds = InclusiveMetricsEvaluator.parseBounds(this.lowerBounds.get(id));
                return VariantExpressionUtil.castTo(fieldLowerBounds.get(bound.path()), bound.type());
            }
            return null;
        }

        private <T> T extractUpperBound(BoundExtract<T> bound) {
            int id = bound.ref().fieldId();
            if (this.upperBounds != null && this.upperBounds.containsKey(id)) {
                VariantObject fieldUpperBounds = InclusiveMetricsEvaluator.parseBounds(this.upperBounds.get(id));
                return VariantExpressionUtil.castTo(fieldUpperBounds.get(bound.path()), bound.type());
            }
            return null;
        }

        private boolean isNonNullPreserving(Bound<?> term) {
            if (term instanceof BoundReference) {
                return true;
            }
            if (term instanceof BoundTransform) {
                return ((BoundTransform)term).transform().preservesOrder();
            }
            return false;
        }
    }
}

