/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.lancedb.lance.namespace.model.JsonArrowSchema;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"version", "location", "schema", "properties", "storage_options"})
public class DescribeTableResponse {
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nullable
    private Long version;
    public static final String JSON_PROPERTY_LOCATION = "location";
    @Nullable
    private String location;
    public static final String JSON_PROPERTY_SCHEMA = "schema";
    @Nullable
    private JsonArrowSchema schema;
    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    @Nullable
    private Map<String, String> properties = new HashMap<String, String>();
    public static final String JSON_PROPERTY_STORAGE_OPTIONS = "storage_options";
    @Nullable
    private Map<String, String> storageOptions = new HashMap<String, String>();

    public DescribeTableResponse version(@Nullable Long version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(@Nullable Long version) {
        this.version = version;
    }

    public DescribeTableResponse location(@Nullable String location) {
        this.location = location;
        return this;
    }

    @Nullable
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocation(@Nullable String location) {
        this.location = location;
    }

    public DescribeTableResponse schema(@Nullable JsonArrowSchema schema) {
        this.schema = schema;
        return this;
    }

    @Nullable
    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonArrowSchema getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchema(@Nullable JsonArrowSchema schema) {
        this.schema = schema;
    }

    public DescribeTableResponse properties(@Nullable Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public DescribeTableResponse putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProperties(@Nullable Map<String, String> properties) {
        this.properties = properties;
    }

    public DescribeTableResponse storageOptions(@Nullable Map<String, String> storageOptions) {
        this.storageOptions = storageOptions;
        return this;
    }

    public DescribeTableResponse putStorageOptionsItem(String key, String storageOptionsItem) {
        if (this.storageOptions == null) {
            this.storageOptions = new HashMap<String, String>();
        }
        this.storageOptions.put(key, storageOptionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="storage_options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getStorageOptions() {
        return this.storageOptions;
    }

    @JsonProperty(value="storage_options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStorageOptions(@Nullable Map<String, String> storageOptions) {
        this.storageOptions = storageOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescribeTableResponse describeTableResponse = (DescribeTableResponse)o;
        return Objects.equals(this.version, describeTableResponse.version) && Objects.equals(this.location, describeTableResponse.location) && Objects.equals(this.schema, describeTableResponse.schema) && Objects.equals(this.properties, describeTableResponse.properties) && Objects.equals(this.storageOptions, describeTableResponse.storageOptions);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.location, this.schema, this.properties, this.storageOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DescribeTableResponse {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    storageOptions: ").append(this.toIndentedString(this.storageOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getVersion() != null) {
            try {
                joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getVersion()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getLocation() != null) {
            try {
                joiner.add(String.format("%slocation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLocation()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSchema() != null) {
            joiner.add(this.getSchema().toUrlQueryString(prefix + JSON_PROPERTY_SCHEMA + suffix));
        }
        if (this.getProperties() != null) {
            for (String _key : this.getProperties().keySet()) {
                try {
                    joiner.add(String.format("%sproperties%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getProperties().get(_key), URLEncoder.encode(String.valueOf(this.getProperties().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getStorageOptions() != null) {
            for (String _key : this.getStorageOptions().keySet()) {
                try {
                    joiner.add(String.format("%sstorage_options%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getStorageOptions().get(_key), URLEncoder.encode(String.valueOf(this.getStorageOptions().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

