/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"namespaces", "page_token"})
public class ListNamespacesResponse {
    public static final String JSON_PROPERTY_NAMESPACES = "namespaces";
    @Nonnull
    private Set<String> namespaces = new LinkedHashSet<String>();
    public static final String JSON_PROPERTY_PAGE_TOKEN = "page_token";
    @Nullable
    private String pageToken;

    public ListNamespacesResponse namespaces(@Nonnull Set<String> namespaces) {
        this.namespaces = namespaces;
        return this;
    }

    public ListNamespacesResponse addNamespacesItem(String namespacesItem) {
        if (this.namespaces == null) {
            this.namespaces = new LinkedHashSet<String>();
        }
        this.namespaces.add(namespacesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="namespaces")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Set<String> getNamespaces() {
        return this.namespaces;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonProperty(value="namespaces")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNamespaces(@Nonnull Set<String> namespaces) {
        this.namespaces = namespaces;
    }

    public ListNamespacesResponse pageToken(@Nullable String pageToken) {
        this.pageToken = pageToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="page_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPageToken() {
        return this.pageToken;
    }

    @JsonProperty(value="page_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPageToken(@Nullable String pageToken) {
        this.pageToken = pageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListNamespacesResponse listNamespacesResponse = (ListNamespacesResponse)o;
        return Objects.equals(this.namespaces, listNamespacesResponse.namespaces) && Objects.equals(this.pageToken, listNamespacesResponse.pageToken);
    }

    public int hashCode() {
        return Objects.hash(this.namespaces, this.pageToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListNamespacesResponse {\n");
        sb.append("    namespaces: ").append(this.toIndentedString(this.namespaces)).append("\n");
        sb.append("    pageToken: ").append(this.toIndentedString(this.pageToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getNamespaces() != null) {
            int i = 0;
            for (String _item : this.getNamespaces()) {
                try {
                    joiner.add(String.format("%snamespaces%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(_item), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            ++i;
        }
        if (this.getPageToken() != null) {
            try {
                joiner.add(String.format("%spage_token%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPageToken()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

