/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.net.InetAddress;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.TransportIpAddress;

public class TcpAddress
extends TransportIpAddress {
    static final long serialVersionUID = 1165319744164017388L;
    private static final LogAdapter logger = LogFactory.getLogger(TcpAddress.class);

    public TcpAddress() {
    }

    public TcpAddress(InetAddress inetAddress, int port) {
        this.setInetAddress(inetAddress);
        this.setPort(port);
    }

    public TcpAddress(int port) {
        this.setPort(port);
    }

    public TcpAddress(String address) {
        if (!this.parseAddress(address)) {
            throw new IllegalArgumentException(address);
        }
    }

    public static Address parse(String address) {
        try {
            TcpAddress a = new TcpAddress();
            if (a.parseAddress(address)) {
                return a;
            }
        }
        catch (Exception ex) {
            logger.error(ex);
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof TcpAddress && super.equals(o);
    }
}

