/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.snmp4j.TransportMapping;
import org.snmp4j.TransportStateReference;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.TransportListener;
import org.snmp4j.util.DefaultThreadFactory;
import org.snmp4j.util.WorkerTask;

public abstract class AbstractTransportMapping<A extends Address>
implements TransportMapping<A> {
    private static final LogAdapter logger = LogFactory.getLogger(AbstractTransportMapping.class);
    protected List<TransportListener> transportListener = new ArrayList<TransportListener>(1);
    protected int maxInboundMessageSize = 65535;
    protected boolean asyncMsgProcessingSupported = true;
    protected Set<A> suspendedAddresses = ConcurrentHashMap.newKeySet(5);
    protected WorkerTask listenWorkerTask;

    @Override
    public abstract Class<? extends Address> getSupportedAddressClass();

    @Override
    public boolean isListening() {
        return this.listenWorkerTask != null;
    }

    @Override
    public abstract void sendMessage(A var1, byte[] var2, TransportStateReference var3, long var4, int var6) throws IOException;

    @Override
    public synchronized void addTransportListener(TransportListener l) {
        if (!this.transportListener.contains(l)) {
            ArrayList<TransportListener> tlCopy = new ArrayList<TransportListener>(this.transportListener);
            tlCopy.add(l);
            this.transportListener = tlCopy;
        }
    }

    @Override
    public synchronized void removeTransportListener(TransportListener l) {
        if (this.transportListener != null && this.transportListener.contains(l)) {
            ArrayList<TransportListener> tlCopy = new ArrayList<TransportListener>(this.transportListener);
            tlCopy.remove(l);
            this.transportListener = tlCopy;
        }
    }

    public synchronized void removeAllTransportListeners() {
        this.transportListener = new ArrayList<TransportListener>(1);
    }

    protected void fireProcessMessage(A address, ByteBuffer buf, TransportStateReference tmStateReference) {
        if (this.transportListener != null) {
            for (TransportListener aTransportListener : this.transportListener) {
                aTransportListener.processMessage(this, address, buf, tmStateReference);
            }
        }
    }

    @Override
    public abstract void close() throws IOException;

    public void suspendAddress(A addressToSuspendSending) {
        if (this.suspendedAddresses.add(addressToSuspendSending)) {
            logger.info("Messages sending to " + addressToSuspendSending + " suspended");
        }
    }

    public boolean resumeAddress(A addressToResumeSending) {
        boolean resumed = this.suspendedAddresses.remove(addressToResumeSending);
        if (resumed) {
            logger.info("Messages sending to " + addressToResumeSending + " resumed");
        }
        return resumed;
    }

    protected void handleDroppedMessageToSend(A address, byte[] message, TransportStateReference transportStateReference, long timeoutMillis, int maxRetries) {
        logger.warn((Serializable)((Object)("Dropped message, because this transport mapping is suspended: address=" + address + ", message=" + OctetString.fromByteArray(message).toHexString())));
    }

    @Override
    public abstract void listen() throws IOException;

    @Override
    public int getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public boolean isAsyncMsgProcessingSupported() {
        return this.asyncMsgProcessingSupported;
    }

    public void setAsyncMsgProcessingSupported(boolean asyncMsgProcessingSupported) {
        this.asyncMsgProcessingSupported = asyncMsgProcessingSupported;
    }

    public void setPriority(int newPriority) {
        WorkerTask lt = this.getListenerWorkerTask();
        if (lt instanceof Thread) {
            ((Thread)((Object)lt)).setPriority(newPriority);
        } else if (lt instanceof DefaultThreadFactory.WorkerThread) {
            ((DefaultThreadFactory.WorkerThread)lt).getThread().setPriority(newPriority);
        }
    }

    public int getPriority() {
        WorkerTask lt = this.getListenerWorkerTask();
        if (lt instanceof Thread) {
            return ((Thread)((Object)lt)).getPriority();
        }
        if (lt instanceof DefaultThreadFactory.WorkerThread) {
            return ((DefaultThreadFactory.WorkerThread)lt).getThread().getPriority();
        }
        return 5;
    }

    public void setThreadName(String name) {
        WorkerTask lt = this.getListenerWorkerTask();
        if (lt instanceof Thread) {
            ((Thread)((Object)lt)).setName(name);
        } else if (lt instanceof DefaultThreadFactory.WorkerThread) {
            ((DefaultThreadFactory.WorkerThread)lt).getThread().setName(name);
        }
    }

    public String getThreadName() {
        WorkerTask lt = this.getListenerWorkerTask();
        if (lt instanceof Thread) {
            return ((Thread)((Object)lt)).getName();
        }
        if (lt instanceof DefaultThreadFactory.WorkerThread) {
            return ((DefaultThreadFactory.WorkerThread)lt).getThread().getName();
        }
        return null;
    }

    protected abstract WorkerTask getListenerWorkerTask();
}

