/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser.markup.decoupled;

import java.util.List;
import org.attoparser.AbstractChainedMarkupHandler;
import org.attoparser.IMarkupHandler;
import org.attoparser.ParseException;
import org.attoparser.select.ParseSelection;
import org.thymeleaf.templateparser.markup.decoupled.DecoupledInjectedAttribute;
import org.thymeleaf.templateparser.markup.decoupled.DecoupledTemplateLogic;
import org.thymeleaf.util.Validate;

public final class DecoupledTemplateLogicMarkupHandler
extends AbstractChainedMarkupHandler {
    private static final int INJECTION_LEVEL = 0;
    private static final char[] INNER_WHITE_SPACE = " ".toCharArray();
    private final DecoupledTemplateLogic decoupledTemplateLogic;
    private final boolean injectAttributes;
    private ParseSelection parseSelection;
    private boolean lastWasInnerWhiteSpace = false;

    public DecoupledTemplateLogicMarkupHandler(DecoupledTemplateLogic decoupledTemplateLogic, IMarkupHandler handler) {
        super(handler);
        Validate.notNull(decoupledTemplateLogic, "Decoupled Template Logic cannot be null");
        this.decoupledTemplateLogic = decoupledTemplateLogic;
        this.injectAttributes = this.decoupledTemplateLogic.hasInjectedAttributes();
    }

    public void setParseSelection(ParseSelection selection) {
        this.parseSelection = selection;
        super.setParseSelection(selection);
    }

    public void handleStandaloneElementEnd(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col) throws ParseException {
        if (this.injectAttributes) {
            this.processInjectedAttributes(line, col);
        }
        super.handleStandaloneElementEnd(buffer, nameOffset, nameLen, minimized, line, col);
    }

    public void handleOpenElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        if (this.injectAttributes) {
            this.processInjectedAttributes(line, col);
        }
        super.handleOpenElementEnd(buffer, nameOffset, nameLen, line, col);
    }

    public void handleInnerWhiteSpace(char[] buffer, int offset, int len, int line, int col) throws ParseException {
        this.lastWasInnerWhiteSpace = true;
        super.handleInnerWhiteSpace(buffer, offset, len, line, col);
    }

    public void handleAttribute(char[] buffer, int nameOffset, int nameLen, int nameLine, int nameCol, int operatorOffset, int operatorLen, int operatorLine, int operatorCol, int valueContentOffset, int valueContentLen, int valueOuterOffset, int valueOuterLen, int valueLine, int valueCol) throws ParseException {
        this.lastWasInnerWhiteSpace = false;
        super.handleAttribute(buffer, nameOffset, nameLen, nameLine, nameCol, operatorOffset, operatorLen, operatorLine, operatorCol, valueContentOffset, valueContentLen, valueOuterOffset, valueOuterLen, valueLine, valueCol);
    }

    private void processInjectedAttributes(int line, int col) throws ParseException {
        if (!this.parseSelection.isMatchingAny(0)) {
            return;
        }
        String[] selectors = this.parseSelection.getCurrentSelection(0);
        if (selectors == null || selectors.length == 0) {
            return;
        }
        for (String selector : selectors) {
            List<DecoupledInjectedAttribute> injectedAttributesForSelector = this.decoupledTemplateLogic.getInjectedAttributesForSelector(selector);
            if (injectedAttributesForSelector == null) continue;
            for (DecoupledInjectedAttribute injectedAttribute : injectedAttributesForSelector) {
                if (!this.lastWasInnerWhiteSpace) {
                    super.handleInnerWhiteSpace(INNER_WHITE_SPACE, 0, 1, line, col);
                }
                super.handleAttribute(injectedAttribute.buffer, injectedAttribute.nameOffset, injectedAttribute.nameLen, line, col, injectedAttribute.operatorOffset, injectedAttribute.operatorLen, line, col, injectedAttribute.valueContentOffset, injectedAttribute.valueContentLen, injectedAttribute.valueOuterOffset, injectedAttribute.valueOuterLen, line, col);
                this.lastWasInnerWhiteSpace = false;
            }
        }
    }
}

