/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.security;

public class SimpleBase64Encoder {
    private static final String PWDCHARS_STRING = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final char[] PWDCHARS_ARRAY = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();

    public static String encode(byte[] bytes) {
        int len = bytes.length;
        StringBuffer encoded = new StringBuffer((len + 2) / 3 * 4);
        int i = 0;
        int j = len;
        while (j >= 3) {
            encoded.append(SimpleBase64Encoder.to64((bytes[i] & 0xFF) << 16 | (bytes[i + 1] & 0xFF) << 8 | bytes[i + 2] & 0xFF, 4));
            i += 3;
            j -= 3;
        }
        if (j == 2) {
            encoded.append(SimpleBase64Encoder.to64((bytes[i] & 0xFF) << 8 | bytes[i + 1] & 0xFF, 3));
        }
        if (j == 1) {
            encoded.append(SimpleBase64Encoder.to64(bytes[i] & 0xFF, 2));
        }
        return encoded.toString();
    }

    public static byte[] decode(String string) {
        int l;
        long d;
        byte[] encoded = string.getBytes();
        int len = encoded.length;
        byte[] decoded = new byte[len * 3 / 4];
        int i = 0;
        int j = len;
        int k = 0;
        while (j >= 4) {
            d = SimpleBase64Encoder.from64(encoded, i, 4);
            j -= 4;
            i += 4;
            l = 2;
            while (l >= 0) {
                decoded[k + l] = (byte)(d & 0xFFL);
                d >>= 8;
                --l;
            }
            k += 3;
        }
        if (j == 3) {
            d = SimpleBase64Encoder.from64(encoded, i, 3);
            l = 1;
            while (l >= 0) {
                decoded[k + l] = (byte)(d & 0xFFL);
                d >>= 8;
                --l;
            }
        }
        if (j == 2) {
            d = SimpleBase64Encoder.from64(encoded, i, 2);
            decoded[k] = (byte)(d & 0xFFL);
        }
        return decoded;
    }

    private static final String to64(long input, int size) {
        StringBuffer result = new StringBuffer(size);
        while (size > 0) {
            --size;
            result.append(PWDCHARS_ARRAY[(int)(input & 0x3FL)]);
            input >>= 6;
        }
        return result.toString();
    }

    private static final long from64(byte[] encoded, int idx, int size) {
        long res = 0L;
        int f = 0;
        while (size > 0) {
            byte d;
            --size;
            long r = 0L;
            if ((d = encoded[idx++]) == 47) {
                r = 1L;
            }
            if (d >= 48 && d <= 57) {
                r = 2 + d - 48;
            }
            if (d >= 65 && d <= 90) {
                r = 12 + d - 65;
            }
            if (d >= 97 && d <= 122) {
                r = 38 + d - 97;
            }
            res += r << f;
            f += 6;
        }
        return res;
    }
}

