/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.couchbase;

import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.java.Cluster;
import org.springframework.boot.actuate.couchbase.CouchbaseHealth;
import org.springframework.boot.actuate.health.AbstractReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import reactor.core.publisher.Mono;

public class CouchbaseReactiveHealthIndicator
extends AbstractReactiveHealthIndicator {
    private final Cluster cluster;

    public CouchbaseReactiveHealthIndicator(Cluster cluster) {
        super("Couchbase health check failed");
        this.cluster = cluster;
    }

    @Override
    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        return this.cluster.reactive().diagnostics().map(diagnostics -> {
            new CouchbaseHealth((DiagnosticsResult)diagnostics).applyTo(builder);
            return builder.build();
        });
    }
}

