/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.util.internal.StringUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import reactor.netty.transport.AddressUtils;
import reactor.netty.transport.logging.AdvancedByteBufFormat;
import reactor.util.annotation.Nullable;

public final class ProxyProvider {
    final String username;
    final String password;
    final SocketAddress address;
    final Predicate<SocketAddress> nonProxyHostPredicate;
    final HttpHeaders httpHeaders;
    final Proxy type;
    final long connectTimeoutMillis;
    static final LoggingHandler LOGGING_HANDLER = AdvancedByteBufFormat.HEX_DUMP.toLoggingHandler("reactor.netty.proxy", LogLevel.DEBUG, Charset.defaultCharset());
    static final String HTTP_PROXY_HOST = "http.proxyHost";
    static final String HTTP_PROXY_PORT = "http.proxyPort";
    static final String HTTP_PROXY_USER = "http.proxyUser";
    static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    static final String HTTPS_PROXY_HOST = "https.proxyHost";
    static final String HTTPS_PROXY_PORT = "https.proxyPort";
    static final String HTTPS_PROXY_USER = "https.proxyUser";
    static final String HTTPS_PROXY_PASSWORD = "https.proxyPassword";
    static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    static final String DEFAULT_NON_PROXY_HOSTS = "localhost|127.*|[::1]";
    static final String SOCKS_PROXY_HOST = "socksProxyHost";
    static final String SOCKS_PROXY_PORT = "socksProxyPort";
    static final String SOCKS_VERSION = "socksProxyVersion";
    static final String SOCKS_VERSION_5 = "5";
    static final String SOCKS_VERSION_4 = "4";
    static final String SOCKS_USERNAME = "java.net.socks.username";
    static final String SOCKS_PASSWORD = "java.net.socks.password";

    public static TypeSpec builder() {
        return new Build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ProxyProvider(Build builder) {
        this.username = builder.username;
        this.password = builder.password != null ? builder.password : this.getPasswordValue(builder.passwordFunction);
        this.nonProxyHostPredicate = builder.nonProxyHostPredicate;
        if (Objects.isNull(builder.address)) {
            if (builder.host == null) throw new IllegalArgumentException("Neither address nor host is specified");
            this.address = AddressUtils.createResolved(builder.host, builder.port);
        } else {
            this.address = builder.address.get();
        }
        this.httpHeaders = builder.httpHeaders.get();
        this.type = builder.type;
        this.connectTimeoutMillis = builder.connectTimeoutMillis;
    }

    public final Proxy getType() {
        return this.type;
    }

    @Deprecated
    public final Supplier<? extends InetSocketAddress> getAddress() {
        return () -> (InetSocketAddress)this.address;
    }

    public final Supplier<? extends SocketAddress> getSocketAddress() {
        return () -> this.address;
    }

    public final SocketAddress getProxyAddress() {
        return this.address;
    }

    public final Predicate<SocketAddress> getNonProxyHostsPredicate() {
        return this.nonProxyHostPredicate;
    }

    public final ProxyHandler newProxyHandler() {
        Socks5ProxyHandler proxyHandler;
        boolean b = Objects.nonNull(this.username) && Objects.nonNull(this.password);
        switch (this.type) {
            case HTTP: {
                proxyHandler = b ? new HttpProxyHandler(this.address, this.username, this.password, this.httpHeaders) : new HttpProxyHandler(this.address, this.httpHeaders);
                break;
            }
            case SOCKS4: {
                proxyHandler = Objects.nonNull(this.username) ? new Socks4ProxyHandler(this.address, this.username) : new Socks4ProxyHandler(this.address);
                break;
            }
            case SOCKS5: {
                proxyHandler = b ? new Socks5ProxyHandler(this.address, this.username, this.password) : new Socks5ProxyHandler(this.address);
                break;
            }
            default: {
                throw new IllegalArgumentException("Proxy type unsupported : " + (Object)((Object)this.type));
            }
        }
        proxyHandler.setConnectTimeoutMillis(this.connectTimeoutMillis);
        return proxyHandler;
    }

    public boolean shouldProxy(SocketAddress address) {
        return address instanceof InetSocketAddress && !this.nonProxyHostPredicate.test(address);
    }

    public void addProxyHandler(Channel channel) {
        Objects.requireNonNull(channel, "channel");
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addFirst("reactor.left.proxyHandler", (ChannelHandler)this.newProxyHandler());
        if (this.type == Proxy.SOCKS4 || this.type == Proxy.SOCKS5) {
            pipeline.addAfter("reactor.left.proxyHandler", "reactor.left.unvoidHandler", (ChannelHandler)UnvoidHandler.INSTANCE);
        }
        if (pipeline.get("reactor.left.loggingHandler") != null) {
            pipeline.addBefore("reactor.left.proxyHandler", "reactor.left.proxyLoggingHandler", (ChannelHandler)LOGGING_HANDLER);
        }
    }

    public String toString() {
        return "ProxyProvider {address=" + this.address + ", nonProxyHosts=" + this.nonProxyHostPredicate + ", type=" + (Object)((Object)this.type) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyProvider that = (ProxyProvider)o;
        return Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.address, that.address) && this.getNonProxyHostsValue() == that.getNonProxyHostsValue() && Objects.equals(this.httpHeaders, that.httpHeaders) && this.type == that.type && this.connectTimeoutMillis == that.connectTimeoutMillis;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.username);
        result = 31 * result + Objects.hashCode(this.password);
        result = 31 * result + Objects.hashCode(this.address);
        result = 31 * result + Boolean.hashCode(this.getNonProxyHostsValue());
        result = 31 * result + Objects.hashCode(this.httpHeaders);
        result = 31 * result + Objects.hashCode((Object)this.type);
        result = 31 * result + Long.hashCode(this.connectTimeoutMillis);
        return result;
    }

    private boolean getNonProxyHostsValue() {
        return this.nonProxyHostPredicate.test(this.address);
    }

    @Nullable
    private String getPasswordValue(@Nullable Function<? super String, ? extends String> passwordFunction) {
        if (this.username == null || passwordFunction == null) {
            return null;
        }
        return passwordFunction.apply(this.username);
    }

    @Nullable
    static ProxyProvider createFrom(Properties properties) {
        Objects.requireNonNull(properties, "properties");
        if (properties.containsKey(HTTP_PROXY_HOST) || properties.containsKey(HTTPS_PROXY_HOST)) {
            return ProxyProvider.createHttpProxyFrom(properties);
        }
        if (properties.containsKey(SOCKS_PROXY_HOST)) {
            return ProxyProvider.createSocksProxyFrom(properties);
        }
        return null;
    }

    static ProxyProvider createHttpProxyFrom(Properties properties) {
        String defaultPort;
        String passwordProperty;
        String userProperty;
        String portProperty;
        String hostProperty;
        if (properties.containsKey(HTTPS_PROXY_HOST)) {
            hostProperty = HTTPS_PROXY_HOST;
            portProperty = HTTPS_PROXY_PORT;
            userProperty = HTTPS_PROXY_USER;
            passwordProperty = HTTPS_PROXY_PASSWORD;
            defaultPort = "443";
        } else {
            hostProperty = HTTP_PROXY_HOST;
            portProperty = HTTP_PROXY_PORT;
            userProperty = HTTP_PROXY_USER;
            passwordProperty = HTTP_PROXY_PASSWORD;
            defaultPort = "80";
        }
        String hostname = Objects.requireNonNull(properties.getProperty(hostProperty), hostProperty);
        int port = ProxyProvider.parsePort(properties.getProperty(portProperty, defaultPort), portProperty);
        String nonProxyHosts = properties.getProperty(HTTP_NON_PROXY_HOSTS, DEFAULT_NON_PROXY_HOSTS);
        RegexShouldProxyPredicate transformedNonProxyHosts = RegexShouldProxyPredicate.fromWildcardedPattern(nonProxyHosts);
        Build proxy = new Build();
        proxy.type(Proxy.HTTP).host(hostname).port(port).nonProxyHostsPredicate(transformedNonProxyHosts);
        if (properties.containsKey(userProperty)) {
            proxy.username(properties.getProperty(userProperty));
            if (properties.containsKey(passwordProperty)) {
                proxy.password(properties.getProperty(passwordProperty));
            } else {
                throw new NullPointerException("Proxy username is set via '" + userProperty + "', but '" + passwordProperty + "' is not set.");
            }
        }
        return proxy.build();
    }

    static ProxyProvider createSocksProxyFrom(Properties properties) {
        String hostname = Objects.requireNonNull(properties.getProperty(SOCKS_PROXY_HOST), SOCKS_PROXY_HOST);
        String version = properties.getProperty(SOCKS_VERSION, SOCKS_VERSION_5);
        if (!SOCKS_VERSION_5.equals(version) && !SOCKS_VERSION_4.equals(version)) {
            String message = "only socks versions 4 and 5 supported but got " + version;
            throw new IllegalArgumentException(message);
        }
        Proxy type = SOCKS_VERSION_5.equals(version) ? Proxy.SOCKS5 : Proxy.SOCKS4;
        int port = ProxyProvider.parsePort(properties.getProperty(SOCKS_PROXY_PORT, "1080"), SOCKS_PROXY_PORT);
        Build proxy = new Build();
        proxy.type(type).host(hostname).port(port);
        if (properties.containsKey(SOCKS_USERNAME)) {
            proxy.username(properties.getProperty(SOCKS_USERNAME));
        }
        if (properties.containsKey(SOCKS_PASSWORD)) {
            proxy.password(properties.getProperty(SOCKS_PASSWORD));
        }
        return proxy.build();
    }

    static int parsePort(String port, String propertyName) {
        Objects.requireNonNull(port, "port");
        Objects.requireNonNull(propertyName, "propertyName");
        if (port.isEmpty()) {
            String message = "expected system property " + propertyName + " to be a number but got empty string";
            throw new IllegalArgumentException(message);
        }
        if (!port.chars().allMatch(Character::isDigit)) {
            String message = "expected system property " + propertyName + " to be a number but got " + port;
            throw new IllegalArgumentException(message);
        }
        return Integer.parseInt(port);
    }

    public static interface Builder {
        public Builder username(String var1);

        public Builder password(Function<? super String, ? extends String> var1);

        public Builder port(int var1);

        public Builder nonProxyHosts(String var1);

        public Builder nonProxyHostsPredicate(Predicate<SocketAddress> var1);

        public Builder httpHeaders(Consumer<HttpHeaders> var1);

        public Builder connectTimeoutMillis(long var1);

        public ProxyProvider build();
    }

    public static interface AddressSpec {
        public Builder host(String var1);

        @Deprecated
        public Builder address(InetSocketAddress var1);

        default public Builder socketAddress(SocketAddress address) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public Builder address(Supplier<? extends InetSocketAddress> var1);

        default public Builder socketAddress(Supplier<? extends SocketAddress> addressSupplier) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface TypeSpec {
        public AddressSpec type(Proxy var1);
    }

    @ChannelHandler.Sharable
    static final class UnvoidHandler
    extends ChannelOutboundHandlerAdapter {
        static final UnvoidHandler INSTANCE = new UnvoidHandler();

        UnvoidHandler() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            ctx.write(msg, promise.unvoid());
        }
    }

    static final class RegexShouldProxyPredicate
    implements Predicate<SocketAddress> {
        public static final RegexShouldProxyPredicate DEFAULT_NON_PROXY = RegexShouldProxyPredicate.fromWildcardedPattern("localhost|127.*|[::1]|0.0.0.0|[::0]");
        private final String regex;
        private final Pattern pattern;

        public static RegexShouldProxyPredicate fromWildcardedPattern(String pattern) {
            String transformed;
            if (StringUtil.isNullOrEmpty((String)pattern)) {
                transformed = "$^";
            } else {
                CharSequence[] parts = pattern.split("\\|");
                for (int i = 0; i < parts.length; ++i) {
                    parts[i] = RegexShouldProxyPredicate.transformWildcardComponent((String)parts[i]);
                }
                transformed = String.join((CharSequence)"|", parts);
            }
            return new RegexShouldProxyPredicate(transformed);
        }

        private static String transformWildcardComponent(String in) {
            CharSequence[] parts = new String[]{"", "", ""};
            if (in.startsWith("*")) {
                parts[0] = ".*";
                in = in.substring(1);
            }
            if (in.endsWith("*")) {
                parts[2] = ".*";
                in = in.substring(0, in.length() - 1);
            }
            parts[1] = Pattern.quote(in);
            return String.join((CharSequence)"", parts);
        }

        private RegexShouldProxyPredicate(String pattern) {
            this.regex = pattern;
            this.pattern = Pattern.compile(this.regex, 2);
        }

        @Override
        public boolean test(SocketAddress socketAddress) {
            if (!(socketAddress instanceof InetSocketAddress)) {
                return false;
            }
            InetSocketAddress isa = (InetSocketAddress)socketAddress;
            String hostString = isa.getHostString();
            return hostString != null && this.pattern.matcher(hostString).matches();
        }

        public String toString() {
            return this.regex;
        }
    }

    static final class Build
    implements TypeSpec,
    AddressSpec,
    Builder {
        static final Supplier<? extends HttpHeaders> NO_HTTP_HEADERS = () -> null;
        static final Predicate<SocketAddress> ALWAYS_PROXY = a -> false;
        String username;
        String password;
        Function<? super String, ? extends String> passwordFunction;
        String host;
        int port;
        Supplier<? extends SocketAddress> address;
        Predicate<SocketAddress> nonProxyHostPredicate = ALWAYS_PROXY;
        Supplier<? extends HttpHeaders> httpHeaders = NO_HTTP_HEADERS;
        Proxy type;
        long connectTimeoutMillis = 10000L;

        Build() {
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public final Builder password(Function<? super String, ? extends String> passwordFunction) {
            this.password = null;
            this.passwordFunction = passwordFunction;
            return this;
        }

        final Builder password(String password) {
            this.password = password;
            this.passwordFunction = null;
            return this;
        }

        @Override
        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            return this;
        }

        @Override
        public final Builder address(InetSocketAddress address) {
            return this.socketAddress(address);
        }

        @Override
        public final Builder port(int port) {
            this.port = port;
            return this;
        }

        @Override
        public final Builder socketAddress(SocketAddress address) {
            Objects.requireNonNull(address, "address");
            this.address = () -> {
                if (address instanceof InetSocketAddress) {
                    return AddressUtils.replaceWithResolved((InetSocketAddress)address);
                }
                return address;
            };
            return this;
        }

        @Override
        public final Builder address(Supplier<? extends InetSocketAddress> addressSupplier) {
            return this.socketAddress(addressSupplier);
        }

        @Override
        public final Builder socketAddress(Supplier<? extends SocketAddress> addressSupplier) {
            this.address = Objects.requireNonNull(addressSupplier, "addressSupplier");
            return this;
        }

        @Override
        public final Builder nonProxyHosts(String nonProxyHostsPattern) {
            return StringUtil.isNullOrEmpty((String)nonProxyHostsPattern) ? this.nonProxyHostsPredicate(ALWAYS_PROXY) : this.nonProxyHostsPredicate(new RegexShouldProxyPredicate(nonProxyHostsPattern));
        }

        @Override
        public final Builder nonProxyHostsPredicate(Predicate<SocketAddress> nonProxyHostsPredicate) {
            this.nonProxyHostPredicate = Objects.requireNonNull(nonProxyHostsPredicate, "nonProxyHostsPredicate");
            return this;
        }

        @Override
        public Builder httpHeaders(final Consumer<HttpHeaders> headers) {
            if (headers != null) {
                this.httpHeaders = () -> new DefaultHttpHeaders(){
                    {
                        headers.accept(this);
                    }
                };
            }
            return this;
        }

        @Override
        public final AddressSpec type(Proxy type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @Override
        public Builder connectTimeoutMillis(long connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return this;
        }

        @Override
        public ProxyProvider build() {
            return new ProxyProvider(this);
        }
    }

    public static enum Proxy {
        HTTP,
        SOCKS4,
        SOCKS5;

    }
}

