/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.word.entity;

import java.io.InputStream;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlToken;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTAnchor;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTInline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyXWPFDocument
extends XWPFDocument {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyXWPFDocument.class);
    private static String PICXML = "<a:graphic xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\">   <a:graphicData uri=\"http://schemas.openxmlformats.org/drawingml/2006/picture\">      <pic:pic xmlns:pic=\"http://schemas.openxmlformats.org/drawingml/2006/picture\">         <pic:nvPicPr>            <pic:cNvPr id=\"%s\" name=\"Generated\"/>            <pic:cNvPicPr/>         </pic:nvPicPr>         <pic:blipFill>            <a:blip r:embed=\"%s\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"/>            <a:stretch>               <a:fillRect/>            </a:stretch>         </pic:blipFill>         <pic:spPr>            <a:xfrm>               <a:off x=\"0\" y=\"0\"/>               <a:ext cx=\"%s\" cy=\"%s\"/>            </a:xfrm>            <a:prstGeom prst=\"rect\">               <a:avLst/>            </a:prstGeom>         </pic:spPr>      </pic:pic>   </a:graphicData></a:graphic>";

    public MyXWPFDocument() {
    }

    public MyXWPFDocument(InputStream in) throws Exception {
        super(in);
    }

    public MyXWPFDocument(OPCPackage opcPackage) throws Exception {
        super(opcPackage);
    }

    public void createPicture(String blipId, int id, int width, int height) {
        int emu = 9525;
        CTInline inline = this.createParagraph().createRun().getCTR().addNewDrawing().addNewInline();
        String picXml = String.format(PICXML, id, blipId, width *= 9525, height *= 9525);
        XmlToken xmlToken = null;
        try {
            xmlToken = XmlToken.Factory.parse((String)picXml);
        }
        catch (XmlException xe) {
            LOGGER.error(xe.getMessage(), (Throwable)xe);
        }
        inline.set((XmlObject)xmlToken);
        inline.setDistT(0L);
        inline.setDistB(0L);
        inline.setDistL(0L);
        inline.setDistR(0L);
        CTPositiveSize2D extent = inline.addNewExtent();
        extent.setCx((long)width);
        extent.setCy((long)height);
        CTNonVisualDrawingProps docPr = inline.addNewDocPr();
        docPr.setId((long)id);
        docPr.setName("Picture " + id);
        docPr.setDescr("Generated");
    }

    public void createPicture(XWPFRun run, String blipId, int id, int width, int height) {
        int emu = 9525;
        CTInline inline = run.getCTR().addNewDrawing().addNewInline();
        String picXml = String.format(PICXML, id, blipId, width *= 9525, height *= 9525);
        XmlToken xmlToken = null;
        try {
            xmlToken = XmlToken.Factory.parse((String)picXml);
        }
        catch (XmlException xe) {
            LOGGER.error(xe.getMessage(), (Throwable)xe);
        }
        inline.set((XmlObject)xmlToken);
        inline.setDistT(0L);
        inline.setDistB(0L);
        inline.setDistL(0L);
        inline.setDistR(0L);
        CTPositiveSize2D extent = inline.addNewExtent();
        extent.setCx((long)width);
        extent.setCy((long)height);
        CTNonVisualDrawingProps docPr = inline.addNewDocPr();
        docPr.setId((long)id);
        docPr.setName("Picture " + id);
        docPr.setDescr("Generated");
    }

    public void createPicture(XWPFRun run, String blipId, int id, int width, int height, boolean isAbove) {
        this.createPicture(run, blipId, id, width, height);
        CTDrawing drawing = run.getCTR().getDrawingArray(0);
        CTGraphicalObject graphicalObject = drawing.getInlineArray(0).getGraphic();
        CTAnchor anchor = MyXWPFDocument.getAnchorWithGraphic(graphicalObject, "EasyPoi" + RandomStringUtils.randomAlphanumeric((int)10), Units.toEMU((double)width), Units.toEMU((double)height), Units.toEMU((double)50.0), Units.toEMU((double)0.0), isAbove);
        drawing.setAnchorArray(new CTAnchor[]{anchor});
        drawing.removeInline(0);
    }

    public static CTAnchor getAnchorWithGraphic(CTGraphicalObject graphicalObject, String deskFileName, int width, int height, int leftOffset, int topOffset, boolean behind) {
        String anchorXML = "<wp:anchor xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\" simplePos=\"0\" relativeHeight=\"0\" behindDoc=\"" + (behind ? 1 : 0) + "\" locked=\"0\" layoutInCell=\"1\" allowOverlap=\"1\"><wp:simplePos x=\"0\" y=\"0\"/><wp:positionH relativeFrom=\"column\"><wp:posOffset>" + leftOffset + "</wp:posOffset></wp:positionH><wp:positionV relativeFrom=\"paragraph\"><wp:posOffset>" + topOffset + "</wp:posOffset></wp:positionV><wp:extent cx=\"" + width + "\" cy=\"" + height + "\"/><wp:effectExtent l=\"0\" t=\"0\" r=\"0\" b=\"0\"/><wp:wrapNone/><wp:docPr id=\"1\" name=\"Drawing 0\" descr=\"" + deskFileName + "\"/><wp:cNvGraphicFramePr/></wp:anchor>";
        CTDrawing drawing = null;
        try {
            drawing = CTDrawing.Factory.parse((String)anchorXML);
        }
        catch (XmlException e) {
            e.printStackTrace();
        }
        CTAnchor anchor = drawing.getAnchorArray(0);
        anchor.setGraphic(graphicalObject);
        return anchor;
    }
}

