/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.ai.agent.adapters.impl;

import com.usthe.sureness.subject.SubjectSum;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.hertzbeat.ai.agent.adapters.MonitorServiceAdapter;
import org.apache.hertzbeat.ai.agent.config.McpContextHolder;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.common.support.SpringContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;

@Component
public class MonitorServiceAdapterImpl
implements MonitorServiceAdapter {
    private static final Logger log = LoggerFactory.getLogger(MonitorServiceAdapterImpl.class);

    @Override
    public Page<Monitor> getMonitors(List<Long> ids, String app, String search, Byte status, String sort, String order, Integer pageIndex, Integer pageSize, String labels) {
        try {
            if (sort == null || sort.trim().isEmpty()) {
                sort = "gmtCreate";
            }
            if (order == null || order.trim().isEmpty()) {
                order = "desc";
            }
            if (pageIndex == null) {
                pageIndex = 0;
            }
            if (pageSize == null) {
                pageSize = 8;
            }
            Object monitorService = null;
            SubjectSum subjectSum = McpContextHolder.getSubject();
            log.debug("Current security subject: {}", (Object)subjectSum);
            try {
                monitorService = SpringContextHolder.getBean((String)"monitorServiceImpl");
            }
            catch (Exception e) {
                log.debug("Could not find bean by name 'monitorServiceImpl', trying by class name");
            }
            assert (monitorService != null);
            log.debug("MonitorService bean found: {}", (Object)monitorService.getClass().getSimpleName());
            Method method = monitorService.getClass().getMethod("getMonitors", List.class, String.class, String.class, Byte.class, String.class, String.class, Integer.TYPE, Integer.TYPE, String.class);
            Page result = (Page)method.invoke(monitorService, ids, app, search, status, sort, order, pageIndex, pageSize, labels);
            log.debug("MonitorServiceAdapter.getMonitors result: {}", (Object)result.getContent());
            return result;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Method not found: getMonitors", e);
        }
        catch (Exception e) {
            log.debug("Failed to invoke getMonitors via adapter", (Throwable)e);
            throw new RuntimeException("Failed to invoke getMonitors via adapter", e);
        }
    }
}

