/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableApplicationEvent;
import org.apache.kafka.common.TopicPartition;

public class FetchCommittedOffsetsApplicationEvent
extends CompletableApplicationEvent<Map<TopicPartition, OffsetAndMetadata>> {
    private final Set<TopicPartition> partitions;
    private final long timeoutMs;

    public FetchCommittedOffsetsApplicationEvent(Set<TopicPartition> partitions, long timeoutMs) {
        super(ApplicationEvent.Type.FETCH_COMMITTED_OFFSETS);
        this.partitions = Collections.unmodifiableSet(partitions);
        this.timeoutMs = timeoutMs;
    }

    public Set<TopicPartition> partitions() {
        return this.partitions;
    }

    public long timeout() {
        return this.timeoutMs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FetchCommittedOffsetsApplicationEvent that = (FetchCommittedOffsetsApplicationEvent)o;
        return this.partitions.equals(that.partitions);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.partitions.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.toStringBase() + ", partitions=" + this.partitions + ", timeout=" + this.timeoutMs + "ms" + '}';
    }
}

