/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import org.springframework.util.Assert;

public class InvalidConfigurationPropertyValueException
extends RuntimeException {
    private final String name;
    private final Object value;
    private final String reason;

    public InvalidConfigurationPropertyValueException(String name, Object value, String reason) {
        this(name, value, reason, null);
    }

    InvalidConfigurationPropertyValueException(String name, Object value, String reason, Throwable cause) {
        super("Property " + name + " with value '" + String.valueOf(value) + "' is invalid: " + reason, cause);
        Assert.notNull((Object)name, (String)"Name must not be null");
        this.name = name;
        this.value = value;
        this.reason = reason;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String getReason() {
        return this.reason;
    }
}

