/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.encryption;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.encryption.spi.EncryptionPluginService;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionPluginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptionPluginManager.class);
    private static final Map<String, EncryptionPluginService> ENCRYPTION_SPI_MAP = new ConcurrentHashMap<String, EncryptionPluginService>();
    private static final EncryptionPluginManager INSTANCE = new EncryptionPluginManager();

    private EncryptionPluginManager() {
        this.loadInitial();
    }

    private void loadInitial() {
        Collection encryptionPluginServices = NacosServiceLoader.load(EncryptionPluginService.class);
        for (EncryptionPluginService encryptionPluginService : encryptionPluginServices) {
            if (StringUtils.isBlank((CharSequence)encryptionPluginService.algorithmName())) {
                LOGGER.warn("[EncryptionPluginManager] Load EncryptionPluginService({}) algorithmName(null/empty) fail. Please Add algorithmName to resolve.", encryptionPluginService.getClass());
                continue;
            }
            ENCRYPTION_SPI_MAP.put(encryptionPluginService.algorithmName(), encryptionPluginService);
            LOGGER.info("[EncryptionPluginManager] Load EncryptionPluginService({}) algorithmName({}) successfully.", encryptionPluginService.getClass(), (Object)encryptionPluginService.algorithmName());
        }
    }

    public static EncryptionPluginManager instance() {
        return INSTANCE;
    }

    public Optional<EncryptionPluginService> findEncryptionService(String algorithmName) {
        return Optional.ofNullable(ENCRYPTION_SPI_MAP.get(algorithmName));
    }

    public static synchronized void join(EncryptionPluginService encryptionPluginService) {
        if (Objects.isNull(encryptionPluginService)) {
            return;
        }
        ENCRYPTION_SPI_MAP.put(encryptionPluginService.algorithmName(), encryptionPluginService);
        LOGGER.info("[EncryptionPluginManager] join successfully.");
    }
}

