/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.storage.StatType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StatProp
implements TBase,
Serializable,
Cloneable,
Comparable<StatProp> {
    private static final TStruct STRUCT_DESC = new TStruct("StatProp");
    private static final TField ALIAS_FIELD_DESC = new TField("alias", 11, 1);
    private static final TField PROP_FIELD_DESC = new TField("prop", 11, 2);
    private static final TField STAT_FIELD_DESC = new TField("stat", 8, 3);
    public byte[] alias;
    public byte[] prop;
    public StatType stat;
    public static final int ALIAS = 1;
    public static final int PROP = 2;
    public static final int STAT = 3;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public StatProp() {
    }

    public StatProp(byte[] alias, byte[] prop, StatType stat) {
        this();
        this.alias = alias;
        this.prop = prop;
        this.stat = stat;
    }

    public static Builder builder() {
        return new Builder();
    }

    public StatProp(StatProp other) {
        if (other.isSetAlias()) {
            this.alias = TBaseHelper.deepCopy(other.alias);
        }
        if (other.isSetProp()) {
            this.prop = TBaseHelper.deepCopy(other.prop);
        }
        if (other.isSetStat()) {
            this.stat = TBaseHelper.deepCopy(other.stat);
        }
    }

    @Override
    public StatProp deepCopy() {
        return new StatProp(this);
    }

    public byte[] getAlias() {
        return this.alias;
    }

    public StatProp setAlias(byte[] alias) {
        this.alias = alias;
        return this;
    }

    public void unsetAlias() {
        this.alias = null;
    }

    public boolean isSetAlias() {
        return this.alias != null;
    }

    public void setAliasIsSet(boolean __value) {
        if (!__value) {
            this.alias = null;
        }
    }

    public byte[] getProp() {
        return this.prop;
    }

    public StatProp setProp(byte[] prop) {
        this.prop = prop;
        return this;
    }

    public void unsetProp() {
        this.prop = null;
    }

    public boolean isSetProp() {
        return this.prop != null;
    }

    public void setPropIsSet(boolean __value) {
        if (!__value) {
            this.prop = null;
        }
    }

    public StatType getStat() {
        return this.stat;
    }

    public StatProp setStat(StatType stat) {
        this.stat = stat;
        return this;
    }

    public void unsetStat() {
        this.stat = null;
    }

    public boolean isSetStat() {
        return this.stat != null;
    }

    public void setStatIsSet(boolean __value) {
        if (!__value) {
            this.stat = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetAlias();
                    break;
                }
                this.setAlias((byte[])__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetProp();
                    break;
                }
                this.setProp((byte[])__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetStat();
                    break;
                }
                this.setStat((StatType)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getAlias();
            }
            case 2: {
                return this.getProp();
            }
            case 3: {
                return this.getStat();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof StatProp)) {
            return false;
        }
        StatProp that = (StatProp)_that;
        if (!TBaseHelper.equalsSlow(this.isSetAlias(), that.isSetAlias(), this.alias, that.alias)) {
            return false;
        }
        if (!TBaseHelper.equalsSlow(this.isSetProp(), that.isSetProp(), this.prop, that.prop)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetStat(), that.isSetStat(), this.stat, that.stat);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.alias, this.prop, this.stat});
    }

    @Override
    public int compareTo(StatProp other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetAlias()).compareTo(other.isSetAlias());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.alias, other.alias);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProp()).compareTo(other.isSetProp());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.prop, other.prop);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStat()).compareTo(other.isSetStat());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.stat, other.stat);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 11) {
                        this.alias = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 11) {
                        this.prop = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 8) {
                        this.stat = StatType.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.alias != null) {
            oprot.writeFieldBegin(ALIAS_FIELD_DESC);
            oprot.writeBinary(this.alias);
            oprot.writeFieldEnd();
        }
        if (this.prop != null) {
            oprot.writeFieldBegin(PROP_FIELD_DESC);
            oprot.writeBinary(this.prop);
            oprot.writeFieldEnd();
        }
        if (this.stat != null) {
            oprot.writeFieldBegin(STAT_FIELD_DESC);
            oprot.writeI32(this.stat == null ? 0 : this.stat.getValue());
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        int i;
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("StatProp");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("alias");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getAlias() == null) {
            sb.append("null");
        } else {
            int __alias_size = Math.min(this.getAlias().length, 128);
            for (i = 0; i < __alias_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getAlias()[i]).length() > 1 ? Integer.toHexString(this.getAlias()[i]).substring(Integer.toHexString(this.getAlias()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getAlias()[i]).toUpperCase());
            }
            if (this.getAlias().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("prop");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getProp() == null) {
            sb.append("null");
        } else {
            int __prop_size = Math.min(this.getProp().length, 128);
            for (i = 0; i < __prop_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getProp()[i]).length() > 1 ? Integer.toHexString(this.getProp()[i]).substring(Integer.toHexString(this.getProp()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getProp()[i]).toUpperCase());
            }
            if (this.getProp().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("stat");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getStat() == null) {
            sb.append("null");
        } else {
            String stat_name;
            String string = stat_name = this.getStat() == null ? "null" : this.getStat().name();
            if (stat_name != null) {
                sb.append(stat_name);
                sb.append(" (");
            }
            sb.append(this.getStat());
            if (stat_name != null) {
                sb.append(")");
            }
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("alias", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(2, new FieldMetaData("prop", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(3, new FieldMetaData("stat", 3, new FieldValueMetaData(8)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(StatProp.class, metaDataMap);
    }

    public static class Builder {
        private byte[] alias;
        private byte[] prop;
        private StatType stat;

        public Builder setAlias(byte[] alias) {
            this.alias = alias;
            return this;
        }

        public Builder setProp(byte[] prop) {
            this.prop = prop;
            return this;
        }

        public Builder setStat(StatType stat) {
            this.stat = stat;
            return this;
        }

        public StatProp build() {
            StatProp result = new StatProp();
            result.setAlias(this.alias);
            result.setProp(this.prop);
            result.setStat(this.stat);
            return result;
        }
    }
}

