/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.RedisCredentials;
import io.lettuce.core.internal.LettuceAssert;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface RedisCredentialsProvider {
    public Mono<RedisCredentials> resolveCredentials();

    public static RedisCredentialsProvider from(Supplier<RedisCredentials> supplier) {
        LettuceAssert.notNull(supplier, "Supplier must not be null");
        return () -> Mono.fromSupplier((Supplier)supplier);
    }

    @FunctionalInterface
    public static interface ImmediateRedisCredentialsProvider
    extends RedisCredentialsProvider {
        @Override
        default public Mono<RedisCredentials> resolveCredentials() {
            return Mono.just((Object)this.resolveCredentialsNow());
        }

        public RedisCredentials resolveCredentialsNow();
    }
}

