/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.KeyValue;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import java.nio.ByteBuffer;

public class KeyValueOutput<K, V>
extends CommandOutput<K, V, KeyValue<K, V>> {
    private K key;
    private boolean hasKey;

    public KeyValueOutput(RedisCodec<K, V> codec) {
        super(codec, null);
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes != null) {
            if (!this.hasKey) {
                this.key = this.codec.decodeKey(bytes);
                this.hasKey = true;
            } else {
                Object value = this.codec.decodeValue(bytes);
                this.output = KeyValue.fromNullable(this.key, value);
            }
        }
    }
}

