/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory.statik;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.DnsRDataA;
import org.pcap4j.packet.DnsRDataAaaa;
import org.pcap4j.packet.DnsRDataCName;
import org.pcap4j.packet.DnsRDataCaa;
import org.pcap4j.packet.DnsRDataHInfo;
import org.pcap4j.packet.DnsRDataMInfo;
import org.pcap4j.packet.DnsRDataMb;
import org.pcap4j.packet.DnsRDataMd;
import org.pcap4j.packet.DnsRDataMf;
import org.pcap4j.packet.DnsRDataMg;
import org.pcap4j.packet.DnsRDataMr;
import org.pcap4j.packet.DnsRDataMx;
import org.pcap4j.packet.DnsRDataNs;
import org.pcap4j.packet.DnsRDataNull;
import org.pcap4j.packet.DnsRDataPtr;
import org.pcap4j.packet.DnsRDataSoa;
import org.pcap4j.packet.DnsRDataTxt;
import org.pcap4j.packet.DnsRDataWks;
import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.IllegalDnsRData;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.UnknownDnsRData;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.DnsResourceRecordType;

public final class StaticDnsRDataFactory
implements PacketFactory<DnsResourceRecord.DnsRData, DnsResourceRecordType> {
    private static final StaticDnsRDataFactory INSTANCE = new StaticDnsRDataFactory();
    private final Map<DnsResourceRecordType, Instantiater> instantiaters = new HashMap<DnsResourceRecordType, Instantiater>();

    private StaticDnsRDataFactory() {
        this.instantiaters.put(DnsResourceRecordType.A, new Instantiater(){

            @Override
            public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return DnsRDataA.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<DnsRDataA> getTargetClass() {
                return DnsRDataA.class;
            }
        });
        this.instantiaters.put(DnsResourceRecordType.NS, new Instantiater(){

            @Override
            public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return DnsRDataNs.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<DnsRDataNs> getTargetClass() {
                return DnsRDataNs.class;
            }
        });
        this.instantiaters.put(DnsResourceRecordType.MD, new Instantiater(){

            @Override
            public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return DnsRDataMd.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<DnsRDataMd> getTargetClass() {
                return DnsRDataMd.class;
            }
        });
        this.instantiaters.put(DnsResourceRecordType.MF, new Instantiater(){

            @Override
            public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return DnsRDataMf.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<DnsRDataMf> getTargetClass() {
                return DnsRDataMf.class;
            }
        });
        this.instantiaters.put(DnsResourceRecordType.CNAME, new Instantiater(){

            @Override
            public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return DnsRDataCName.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<DnsRDataCName> getTargetClass() {
                return DnsRDataCName.class;
            }
        });
        this.instantiaters.put(DnsResourceRecordType.SOA, new Instantiater(){

            @Override
            public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return DnsRDataSoa.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<DnsRDataSoa> getTargetClass() {
                return DnsRDataSoa.class;
            }
        });
        this.instantiaters.put(DnsResourceRecordType.MB, new Instantiater(){

            @Override
            public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return DnsRDataMb.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<DnsRDataMb> getTargetClass() {
                return DnsRDataMb.class;
            }
        });
        this.instantiaters.put(DnsResourceRecordType.MG, new Instantiater(){

            @Override
            public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return DnsRDataMg.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<DnsRDataMg> getTargetClass() {
                return DnsRDataMg.class;
            }
        });
        this.instantiaters.put(DnsResourceRecordType.MR, new Instantiater(){

            @Override
            public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return DnsRDataMr.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<DnsRDataMr> getTargetClass() {
                return DnsRDataMr.class;
            }
        });
        this.instantiaters.put(DnsResourceRecordType.NULL, new Instantiater(){

            @Override
            public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return DnsRDataNull.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<DnsRDataNull> getTargetClass() {
                return DnsRDataNull.class;
            }
        });
        this.instantiaters.put(DnsResourceRecordType.WKS, new Instantiater(){

            @Override
            public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return DnsRDataWks.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<DnsRDataWks> getTargetClass() {
                return DnsRDataWks.class;
            }
        });
        this.instantiaters.put(DnsResourceRecordType.PTR, new Instantiater(){

            @Override
            public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return DnsRDataPtr.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<DnsRDataPtr> getTargetClass() {
                return DnsRDataPtr.class;
            }
        });
        this.instantiaters.put(DnsResourceRecordType.HINFO, new Instantiater(){

            @Override
            public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return DnsRDataHInfo.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<DnsRDataHInfo> getTargetClass() {
                return DnsRDataHInfo.class;
            }
        });
        this.instantiaters.put(DnsResourceRecordType.MINFO, new Instantiater(){

            @Override
            public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return DnsRDataMInfo.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<DnsRDataMInfo> getTargetClass() {
                return DnsRDataMInfo.class;
            }
        });
        this.instantiaters.put(DnsResourceRecordType.MX, new Instantiater(){

            @Override
            public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return DnsRDataMx.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<DnsRDataMx> getTargetClass() {
                return DnsRDataMx.class;
            }
        });
        this.instantiaters.put(DnsResourceRecordType.TXT, new Instantiater(){

            @Override
            public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return DnsRDataTxt.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<DnsRDataTxt> getTargetClass() {
                return DnsRDataTxt.class;
            }
        });
        this.instantiaters.put(DnsResourceRecordType.AAAA, new Instantiater(){

            @Override
            public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return DnsRDataAaaa.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<DnsRDataAaaa> getTargetClass() {
                return DnsRDataAaaa.class;
            }
        });
        this.instantiaters.put(DnsResourceRecordType.CAA, new Instantiater(){

            @Override
            public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return DnsRDataCaa.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<DnsRDataCaa> getTargetClass() {
                return DnsRDataCaa.class;
            }
        });
    }

    public static StaticDnsRDataFactory getInstance() {
        return INSTANCE;
    }

    public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length, DnsResourceRecordType number) {
        if (rawData == null || number == null) {
            StringBuilder sb = new StringBuilder(40);
            sb.append("rawData: ").append(rawData).append(" number: ").append(number);
            throw new NullPointerException(sb.toString());
        }
        try {
            Instantiater instantiater = this.instantiaters.get(number);
            if (instantiater != null) {
                return instantiater.newInstance(rawData, offset, length);
            }
        }
        catch (IllegalRawDataException e) {
            return IllegalDnsRData.newInstance((byte[])rawData, (int)offset, (int)length);
        }
        return this.newInstance(rawData, offset, length);
    }

    public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length) {
        return UnknownDnsRData.newInstance((byte[])rawData, (int)offset, (int)length);
    }

    public Class<? extends DnsResourceRecord.DnsRData> getTargetClass(DnsResourceRecordType number) {
        if (number == null) {
            throw new NullPointerException("number must not be null.");
        }
        Instantiater instantiater = this.instantiaters.get(number);
        return instantiater != null ? instantiater.getTargetClass() : this.getTargetClass();
    }

    public Class<? extends DnsResourceRecord.DnsRData> getTargetClass() {
        return UnknownDnsRData.class;
    }

    private static interface Instantiater {
        public DnsResourceRecord.DnsRData newInstance(byte[] var1, int var2, int var3) throws IllegalRawDataException;

        public Class<? extends DnsResourceRecord.DnsRData> getTargetClass();
    }
}

