/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.jmx;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.collector.collect.jmx.JmxValidator;
import org.apache.hertzbeat.collector.collect.jmx.MbeanProcessor;
import org.apache.hertzbeat.collector.collect.jmx.kafkajmx.KafkaJmxValidator;

public class CustomizedJmxFactory {
    private static final Map<String, JmxValidator> VALIDATOR_MAP;

    public static boolean validate(String app, String objectName) {
        if (StringUtils.isBlank((CharSequence)app) || StringUtils.isBlank((CharSequence)objectName)) {
            return false;
        }
        JmxValidator validator = VALIDATOR_MAP.get(app.toLowerCase());
        if (validator == null) {
            return false;
        }
        return validator.isValid(objectName);
    }

    public static MbeanProcessor getProcessor(String app, String objectName) {
        if (StringUtils.isBlank((CharSequence)app) || StringUtils.isBlank((CharSequence)objectName)) {
            return null;
        }
        JmxValidator validator = VALIDATOR_MAP.get(app.toLowerCase());
        if (validator == null) {
            return null;
        }
        return validator.getProcessor(objectName);
    }

    static {
        HashMap<String, KafkaJmxValidator> map = new HashMap<String, KafkaJmxValidator>();
        map.put("kafka", new KafkaJmxValidator());
        VALIDATOR_MAP = Collections.unmodifiableMap(map);
    }
}

