/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ssh;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.common.cache.CacheIdentifier;
import org.apache.hertzbeat.collector.collect.common.cache.GlobalConnectionCache;
import org.apache.hertzbeat.collector.collect.common.ssh.CommonSshBlacklist;
import org.apache.hertzbeat.collector.collect.common.ssh.SshHelper;
import org.apache.hertzbeat.collector.util.CollectUtil;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.SshProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.exception.SshChannelOpenException;
import org.apache.sshd.common.util.io.output.NoCloseOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SshCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(SshCollectImpl.class);
    private static final String PARSE_TYPE_ONE_ROW = "oneRow";
    private static final String PARSE_TYPE_MULTI_ROW = "multiRow";
    private static final String PARSE_TYPE_NETCAT = "netcat";
    private static final String PARSE_TYPE_LOG = "log";
    private static final int DEFAULT_TIMEOUT = 10000;
    private final GlobalConnectionCache connectionCommonCache = GlobalConnectionCache.getInstance();

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        if (metrics == null || metrics.getSsh() == null) {
            throw new IllegalArgumentException("ssh collect must has ssh params");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        String errorMsg;
        long startTime = System.currentTimeMillis();
        SshProtocol sshProtocol = metrics.getSsh();
        boolean reuseConnection = Boolean.parseBoolean(sshProtocol.getReuseConnection());
        boolean useProxy = Boolean.parseBoolean(sshProtocol.getUseProxy());
        int timeout = CollectUtil.getTimeout((String)sshProtocol.getTimeout(), (int)10000);
        ChannelExec channel = null;
        ClientSession clientSession = null;
        try {
            clientSession = this.getConnectSession(sshProtocol, timeout, reuseConnection, useProxy);
            if (CommonSshBlacklist.isCommandBlacklisted((String)sshProtocol.getScript())) {
                builder.setCode(CollectRep.Code.FAIL);
                builder.setMsg("The command is blacklisted: " + sshProtocol.getScript());
                log.warn("The command is blacklisted: {}", (Object)sshProtocol.getScript());
                return;
            }
            channel = clientSession.createExecChannel(sshProtocol.getScript());
            ByteArrayOutputStream response = new ByteArrayOutputStream();
            channel.setOut((OutputStream)response);
            channel.setErr((OutputStream)new NoCloseOutputStream((OutputStream)System.err));
            channel.open().verify((long)timeout);
            ArrayList<ClientChannelEvent> list = new ArrayList<ClientChannelEvent>();
            list.add(ClientChannelEvent.CLOSED);
            Set waitEvents = channel.waitFor(list, (long)timeout);
            if (waitEvents.contains(ClientChannelEvent.TIMEOUT)) {
                int cancelSignal = 3;
                channel.getInvertedIn().write(cancelSignal);
                channel.getInvertedIn().flush();
                throw new SocketTimeoutException("Failed to retrieve command result in time: " + sshProtocol.getScript());
            }
            Long responseTime = System.currentTimeMillis() - startTime;
            String result = response.toString();
            if (!StringUtils.hasText((String)result)) {
                builder.setCode(CollectRep.Code.FAIL);
                builder.setMsg("ssh shell response data is null");
                return;
            }
            switch (sshProtocol.getParseType()) {
                case "log": {
                    this.parseResponseDataByLog(result, metrics.getAliasFields(), builder, responseTime);
                    return;
                }
                case "netcat": {
                    this.parseResponseDataByNetcat(result, metrics.getAliasFields(), builder, responseTime);
                    return;
                }
                case "oneRow": {
                    this.parseResponseDataByOne(result, metrics.getAliasFields(), builder, responseTime);
                    return;
                }
                case "multiRow": {
                    this.parseResponseDataByMulti(result, metrics.getAliasFields(), builder, responseTime);
                    return;
                }
                default: {
                    builder.setCode(CollectRep.Code.FAIL);
                    builder.setMsg("Ssh collect not support this parse type: " + sshProtocol.getParseType());
                    return;
                }
            }
        }
        catch (ConnectException connectException) {
            errorMsg = CommonUtil.getMessageFromThrowable((Throwable)connectException);
            log.info(errorMsg);
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg("The peer refused to connect: service port does not listening or firewall: " + errorMsg);
            return;
        }
        catch (SshException sshException) {
            Throwable throwable = sshException.getCause();
            if (throwable instanceof SshChannelOpenException) {
                log.warn("Remote ssh server no more session channel, please increase sshd_config MaxSessions.");
            }
            String errorMsg2 = CommonUtil.getMessageFromThrowable((Throwable)sshException);
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg("Peer ssh connection failed: " + errorMsg2);
            return;
        }
        catch (IOException ioException) {
            errorMsg = CommonUtil.getMessageFromThrowable((Throwable)ioException);
            log.info(errorMsg);
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg("Peer io connection failed: " + errorMsg);
            return;
        }
        catch (Exception exception) {
            errorMsg = CommonUtil.getMessageFromThrowable((Throwable)exception);
            log.warn(errorMsg, (Throwable)exception);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
            return;
        }
        finally {
            if (channel != null && channel.isOpen()) {
                try {
                    long st = System.currentTimeMillis();
                    channel.close(false).addListener(future -> log.debug("channel is closed in {} ms", (Object)(System.currentTimeMillis() - st)));
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (clientSession != null && !reuseConnection && !useProxy) {
                try {
                    clientSession.close();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public String supportProtocol() {
        return "ssh";
    }

    private void parseResponseDataByLog(String result, List<String> aliasFields, CollectRep.MetricsData.Builder builder, Long responseTime) {
        String[] lines = result.split("\n");
        if (lines.length + 1 < aliasFields.size()) {
            log.error("ssh response data not enough: {}", (Object)result);
            return;
        }
        for (String line : lines) {
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            for (String alias : aliasFields) {
                if ("responseTime".equalsIgnoreCase(alias)) {
                    valueRowBuilder.addColumn(responseTime.toString());
                    continue;
                }
                valueRowBuilder.addColumn(line);
            }
            builder.addValueRow(valueRowBuilder.build());
        }
    }

    private void parseResponseDataByNetcat(String result, List<String> aliasFields, CollectRep.MetricsData.Builder builder, Long responseTime) {
        String[] lines = result.split("\n");
        if (lines.length + 1 < aliasFields.size()) {
            log.error("ssh response data not enough: {}", (Object)result);
            return;
        }
        boolean contains = lines[0].contains("=");
        Map<String, String> mapValue = Arrays.stream(lines).map(item -> {
            if (contains) {
                return item.split("=");
            }
            return item.split("\t");
        }).filter(item -> ((String[])item).length == 2).collect(Collectors.toMap(x -> x[0], x -> x[1]));
        CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
        for (String field : aliasFields) {
            String fieldValue = mapValue.get(field);
            valueRowBuilder.addColumn(Objects.requireNonNullElse(fieldValue, "&nbsp;"));
        }
        builder.addValueRow(valueRowBuilder.build());
    }

    private void parseResponseDataByOne(String result, List<String> aliasFields, CollectRep.MetricsData.Builder builder, Long responseTime) {
        String[] lines = result.split("\n");
        if (lines.length + 1 < aliasFields.size()) {
            log.error("ssh response data not enough: {}", (Object)result);
            return;
        }
        CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
        int lineIndex = 0;
        for (int aliasIndex = 0; aliasIndex < aliasFields.size(); ++aliasIndex) {
            if ("responseTime".equalsIgnoreCase(aliasFields.get(aliasIndex))) {
                valueRowBuilder.addColumn(responseTime.toString());
                continue;
            }
            if (lineIndex < lines.length) {
                valueRowBuilder.addColumn(lines[lineIndex].trim());
            } else {
                valueRowBuilder.addColumn("&nbsp;");
            }
            ++lineIndex;
        }
        builder.addValueRow(valueRowBuilder.build());
    }

    private void parseResponseDataByMulti(String result, List<String> aliasFields, CollectRep.MetricsData.Builder builder, Long responseTime) {
        int i;
        String[] lines = result.split("\n");
        if (lines.length <= 1) {
            log.error("ssh response data only has header: {}", (Object)result);
            return;
        }
        String[] fields = lines[0].split(" ");
        HashMap<String, Integer> fieldMapping = new HashMap<String, Integer>(fields.length);
        for (i = 0; i < fields.length; ++i) {
            fieldMapping.put(fields[i].trim().toLowerCase(), i);
        }
        for (i = 1; i < lines.length; ++i) {
            String[] values = lines[i].split(" ");
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            for (String alias : aliasFields) {
                if ("responseTime".equalsIgnoreCase(alias)) {
                    valueRowBuilder.addColumn(responseTime.toString());
                    continue;
                }
                Integer index = (Integer)fieldMapping.get(alias.toLowerCase());
                if (index != null && index < values.length) {
                    valueRowBuilder.addColumn(values[index]);
                    continue;
                }
                valueRowBuilder.addColumn("&nbsp;");
            }
            builder.addValueRow(valueRowBuilder.build());
        }
    }

    private void removeConnectSessionCache(SshProtocol sshProtocol) {
        CacheIdentifier identifier = CacheIdentifier.builder().ip(sshProtocol.getHost()).port(sshProtocol.getPort()).username(sshProtocol.getUsername()).password(sshProtocol.getPassword()).build();
        this.connectionCommonCache.removeCache((Object)identifier);
    }

    private ClientSession getConnectSession(SshProtocol sshProtocol, int timeout, boolean reuseConnection, boolean useProxy) throws IOException, GeneralSecurityException {
        return SshHelper.getConnectSession((SshProtocol)sshProtocol, (int)timeout, (boolean)reuseConnection, (boolean)useProxy);
    }
}

