/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.codegen.fields;

import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.plc4x.java.spi.codegen.FieldCommons;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.generation.ParseAssertException;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithReaderWriterArgs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldReaderOptional<T>
implements FieldCommons,
WithReaderWriterArgs {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldReaderOptional.class);

    public T readOptionalField(String logicalName, DataReader<T> dataReader, boolean condition, WithReaderArgs ... readerArgs) throws ParseException {
        LOGGER.debug("reading field {}", (Object)logicalName);
        if (!condition) {
            LOGGER.debug("Condition doesn't match for field {}", (Object)logicalName);
            return null;
        }
        Optional<String> nullByteHexOptional = this.extractNullBytesHex(readerArgs);
        if (nullByteHexOptional.isPresent()) {
            int pos;
            ReadBuffer readBuffer;
            block8: {
                String nullByteHex = nullByteHexOptional.get();
                byte[] nullBytes = Hex.decodeHex((String)nullByteHex);
                readBuffer = dataReader.getReadBuffer();
                pos = readBuffer.getPos();
                byte[] curBytes = readBuffer.readByteArray("logicalName", nullBytes.length, readerArgs);
                if (!Arrays.equals(nullBytes, curBytes)) break block8;
                return null;
            }
            try {
                readBuffer.reset(pos);
            }
            catch (DecoderException nullBytes) {
                // empty catch block
            }
        }
        int curPos = dataReader.getPos();
        try {
            Object field = this.switchParseByteOrderIfNecessary(() -> dataReader.read(logicalName, readerArgs), dataReader, this.extractByteOrder(readerArgs).orElse(null));
            LOGGER.debug("done reading field {}. Value: {}", (Object)logicalName, field);
            return (T)field;
        }
        catch (ParseAssertException e) {
            LOGGER.debug("Assertion doesn't match for field {}. Resetting read position to {}", new Object[]{logicalName, curPos, e});
            dataReader.setPos(curPos);
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.debug("Not enough bytes for {}. Resetting read position to {}", new Object[]{logicalName, curPos, e});
            dataReader.setPos(curPos);
            return null;
        }
    }
}

