/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.dataconnector.show;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.dataconnector.show.ShowDataConnectorsDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1211})
public class ShowDataConnectorsAnalyzer
extends BaseSemanticAnalyzer {
    public ShowDataConnectorsAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() > 1) {
            throw new SemanticException("Unexpected Tokens at SHOW CONNECTORS");
        }
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        String connectorPattern = root.getChildCount() == 1 ? ShowDataConnectorsAnalyzer.unescapeSQLString(root.getChild(0).getText()) : null;
        ShowDataConnectorsDesc desc = new ShowDataConnectorsDesc(this.ctx.getResFile(), connectorPattern);
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask("connector_name#string"));
    }
}

