/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.esriJson;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.SpatialReference;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.hive.ql.io.esriJson.EsriFeature;
import org.apache.hadoop.hive.ql.io.esriJson.EsriFeatureClass;
import org.apache.hadoop.hive.serde2.esriJson.deserializer.GeometryJsonDeserializer;
import org.apache.hadoop.hive.serde2.esriJson.deserializer.GeometryTypeJsonDeserializer;
import org.apache.hadoop.hive.serde2.esriJson.deserializer.SpatialReferenceJsonDeserializer;
import org.apache.hadoop.hive.serde2.esriJson.serializer.GeometryJsonSerializer;
import org.apache.hadoop.hive.serde2.esriJson.serializer.GeometryTypeJsonSerializer;
import org.apache.hadoop.hive.serde2.esriJson.serializer.SpatialReferenceJsonSerializer;

public class EsriJsonFactory {
    private static final ObjectMapper jsonObjectMapper;
    private static final JsonFactory jsonFactory;

    private EsriJsonFactory() {
    }

    public static String JsonFromFeatureClass(EsriFeatureClass featureClass) throws JsonGenerationException, JsonMappingException, IOException {
        return jsonObjectMapper.writeValueAsString((Object)featureClass);
    }

    public static EsriFeatureClass FeatureClassFromJson(InputStream jsonInputStream) throws JsonParseException, IOException {
        JsonParser parser = jsonFactory.createJsonParser(jsonInputStream);
        return EsriJsonFactory.FeatureClassFromJson(parser);
    }

    public static EsriFeatureClass FeatureClassFromJson(JsonParser parser) throws JsonProcessingException, IOException {
        parser.setCodec((ObjectCodec)jsonObjectMapper);
        return (EsriFeatureClass)parser.readValueAs(EsriFeatureClass.class);
    }

    public static String JsonFromFeature(EsriFeature feature) throws JsonGenerationException, JsonMappingException, IOException {
        return jsonObjectMapper.writeValueAsString((Object)feature);
    }

    public static EsriFeature FeatureFromJson(InputStream jsonInputStream) throws JsonParseException, IOException {
        JsonParser parser = jsonFactory.createJsonParser(jsonInputStream);
        return EsriJsonFactory.FeatureFromJson(parser);
    }

    public static EsriFeature FeatureFromJson(JsonParser parser) throws JsonProcessingException, IOException {
        parser.setCodec((ObjectCodec)jsonObjectMapper);
        return (EsriFeature)parser.readValueAs(EsriFeature.class);
    }

    static {
        jsonFactory = new JsonFactory();
        jsonObjectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule("EsriJsonModule", new Version(1, 0, 0, null));
        module.addDeserializer(Geometry.class, (JsonDeserializer)new GeometryJsonDeserializer());
        module.addDeserializer(SpatialReference.class, (JsonDeserializer)new SpatialReferenceJsonDeserializer());
        module.addDeserializer(Geometry.Type.class, (JsonDeserializer)new GeometryTypeJsonDeserializer());
        module.addSerializer(Geometry.class, (JsonSerializer)new GeometryJsonSerializer());
        module.addSerializer(Geometry.Type.class, (JsonSerializer)new GeometryTypeJsonSerializer());
        module.addSerializer(SpatialReference.class, (JsonSerializer)new SpatialReferenceJsonSerializer());
        jsonObjectMapper.registerModule((Module)module);
    }
}

