/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata.formatting;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanResponse;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;

class TextMetaDataFormatter
implements MetaDataFormatter {
    private static final int TERMINATOR = 10;
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    TextMetaDataFormatter() {
    }

    @Override
    public void error(OutputStream out, String msg, int errorCode, String sqlState) throws HiveException {
        this.error(out, msg, errorCode, sqlState, null);
    }

    @Override
    public void error(OutputStream out, String errorMessage, int errorCode, String sqlState, String errorDetail) throws HiveException {
        try {
            out.write(errorMessage.getBytes("UTF-8"));
            if (errorDetail != null) {
                out.write(errorDetail.getBytes("UTF-8"));
            }
            out.write(errorCode);
            if (sqlState != null) {
                out.write(sqlState.getBytes("UTF-8"));
            }
            out.write(10);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    private static byte[] str(String str) {
        return str.getBytes(UTF_8);
    }

    private static void write(DataOutputStream out, String val) throws IOException {
        out.write(TextMetaDataFormatter.str(val));
    }

    @Override
    public void showErrors(DataOutputStream out, WMValidateResourcePlanResponse response) throws HiveException {
        try {
            for (String error : response.getErrors()) {
                TextMetaDataFormatter.write(out, error);
                out.write(10);
            }
            for (String warning : response.getWarnings()) {
                TextMetaDataFormatter.write(out, "warn: ");
                TextMetaDataFormatter.write(out, warning);
                out.write(10);
            }
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
    }
}

