/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.ptf;

import org.apache.hadoop.hive.ql.parse.WindowingSpec;

public class BoundaryDef {
    WindowingSpec.Direction direction;
    private int amt;
    private final int relativeOffset;

    public BoundaryDef(WindowingSpec.Direction direction, int amt) {
        this.direction = direction;
        this.amt = amt;
        switch (this.direction) {
            case PRECEDING: {
                this.relativeOffset = -amt;
                break;
            }
            case FOLLOWING: {
                this.relativeOffset = amt;
                break;
            }
            default: {
                this.relativeOffset = 0;
            }
        }
    }

    public WindowingSpec.Direction getDirection() {
        return this.direction;
    }

    public boolean isPreceding() {
        return this.direction == WindowingSpec.Direction.PRECEDING;
    }

    public boolean isFollowing() {
        return this.direction == WindowingSpec.Direction.FOLLOWING;
    }

    public boolean isCurrentRow() {
        return this.direction == WindowingSpec.Direction.CURRENT;
    }

    public int getAmt() {
        return this.amt;
    }

    public int getRelativeOffset() {
        return this.relativeOffset;
    }

    public boolean isUnbounded() {
        return this.getAmt() == Integer.MAX_VALUE;
    }

    public int compareTo(BoundaryDef other) {
        int c = this.getDirection().compareTo(other.getDirection());
        if (c != 0) {
            return c;
        }
        return this.direction == WindowingSpec.Direction.PRECEDING ? other.amt - this.amt : this.amt - other.amt;
    }

    public String toString() {
        if (this.direction == null) {
            return "";
        }
        if (this.direction == WindowingSpec.Direction.CURRENT) {
            return WindowingSpec.Direction.CURRENT.toString();
        }
        return String.valueOf((Object)this.direction) + "(" + String.valueOf(this.getAmt() == Integer.MAX_VALUE ? "MAX" : Integer.valueOf(this.getAmt())) + ")";
    }
}

