/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.instance;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.atlas.model.PList;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasRelationshipHeader
extends AtlasStruct
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String guid = null;
    private AtlasEntity.Status status = AtlasEntity.Status.ACTIVE;
    private AtlasRelationshipDef.PropagateTags propagateTags = AtlasRelationshipDef.PropagateTags.NONE;
    private String label = null;
    private AtlasObjectId end1 = null;
    private AtlasObjectId end2 = null;

    public AtlasRelationshipHeader() {
    }

    public AtlasRelationshipHeader(String typeName, String guid) {
        super(typeName);
        this.setGuid(guid);
    }

    public AtlasRelationshipHeader(String typeName, String guid, AtlasObjectId end1, AtlasObjectId end2, AtlasRelationshipDef.PropagateTags propagateTags) {
        this(typeName, guid);
        this.propagateTags = propagateTags;
        this.setEnd1(end1);
        this.setEnd2(end2);
    }

    public AtlasRelationshipHeader(AtlasRelationship relationship) {
        this(relationship.getTypeName(), relationship.getGuid(), relationship.getEnd1(), relationship.getEnd2(), relationship.getPropagateTags());
        this.setLabel(relationship.getLabel());
        switch (relationship.getStatus()) {
            case ACTIVE: {
                this.setStatus(AtlasEntity.Status.ACTIVE);
                break;
            }
            case DELETED: {
                this.setStatus(AtlasEntity.Status.DELETED);
            }
        }
    }

    public AtlasRelationshipHeader(AtlasRelationship relationship, boolean withAttributes) {
        this(relationship);
        if (withAttributes) {
            this.setAttributes(relationship.getAttributes());
        }
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public AtlasEntity.Status getStatus() {
        return this.status;
    }

    public void setStatus(AtlasEntity.Status status) {
        this.status = status;
    }

    public AtlasRelationshipDef.PropagateTags getPropagateTags() {
        return this.propagateTags;
    }

    public void setPropagateTags(AtlasRelationshipDef.PropagateTags propagateTags) {
        this.propagateTags = propagateTags;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public AtlasObjectId getEnd1() {
        return this.end1;
    }

    public void setEnd1(AtlasObjectId end1) {
        this.end1 = end1;
    }

    public AtlasObjectId getEnd2() {
        return this.end2;
    }

    public void setEnd2(AtlasObjectId end2) {
        this.end2 = end2;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasRelationshipHeader{");
        sb.append("guid='").append(this.guid).append('\'');
        sb.append(", status=").append((Object)this.status);
        sb.append(", label=").append(this.label);
        sb.append(", propagateTags=").append((Object)this.propagateTags);
        sb.append(", end1=").append(this.end1);
        sb.append(", end2=").append(this.end2);
        super.toString(sb);
        sb.append('}');
        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlasRelationshipHeader that = (AtlasRelationshipHeader)o;
        return Objects.equals(this.guid, that.guid) && this.status == that.status && Objects.equals(this.label, that.label) && Objects.equals((Object)this.propagateTags, (Object)that.propagateTags) && Objects.equals(this.end1, that.end1) && Objects.equals(this.end2, that.end2);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.guid, this.status, this.label, this.propagateTags, this.end1, this.end2});
    }

    @Override
    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @XmlSeeAlso(value={AtlasEntity.class})
    public static class AtlasRelationshipHeaders
    extends PList<AtlasRelationshipHeader> {
        private static final long serialVersionUID = 1L;

        public AtlasRelationshipHeaders() {
        }

        public AtlasRelationshipHeaders(List<AtlasRelationshipHeader> list) {
            super(list);
        }

        public AtlasRelationshipHeaders(List list, long startIndex, int pageSize, long totalCount, SearchFilter.SortType sortType, String sortBy) {
            super(list, startIndex, pageSize, totalCount, sortType, sortBy);
        }
    }
}

