/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import java.math.BigDecimal;
import java.time.DateTimeException;
import java.util.Objects;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveDecimalV1;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hive.common.util.DateParser;

public class TimestampUtils {
    public static final BigDecimal BILLION_BIG_DECIMAL = BigDecimal.valueOf(1000000000L);
    private static final int DATE_LENGTH = "YYYY-MM-DD".length();

    public static double getDouble(Timestamp ts) {
        long seconds = ts.toEpochSecond();
        return (double)seconds + (double)ts.getNanos() / 1.0E9;
    }

    public static Timestamp doubleToTimestamp(double f) {
        try {
            long seconds = (long)f;
            BigDecimal bd = new BigDecimal(String.valueOf(f));
            bd = bd.subtract(new BigDecimal(seconds)).multiply(new BigDecimal(1000000000));
            int nanos = bd.intValue();
            long millis = seconds * 1000L;
            if (nanos < 0) {
                millis -= 1000L;
                nanos += 1000000000;
            }
            return Timestamp.ofEpochMilli(millis, nanos);
        }
        catch (IllegalArgumentException | DateTimeException nfe) {
            return null;
        }
    }

    public static Timestamp decimalToTimestamp(HiveDecimal dec) {
        try {
            HiveDecimalWritable nanosWritable = new HiveDecimalWritable(dec);
            nanosWritable.mutateFractionPortion();
            nanosWritable.mutateScaleByPowerOfTen(9);
            if (!nanosWritable.isSet() || !nanosWritable.isInt()) {
                return null;
            }
            int nanos = nanosWritable.intValue();
            if (nanos < 0) {
                nanos += 1000000000;
            }
            nanosWritable.setFromLong((long)nanos);
            HiveDecimalWritable nanoInstant = new HiveDecimalWritable(dec);
            nanoInstant.mutateScaleByPowerOfTen(9);
            nanoInstant.mutateSubtract(nanosWritable);
            nanoInstant.mutateScaleByPowerOfTen(-9);
            if (!nanoInstant.isSet() || !nanoInstant.isLong()) {
                return null;
            }
            long millis = nanoInstant.longValue() * 1000L;
            return Timestamp.ofEpochMilli(millis, nanos);
        }
        catch (IllegalArgumentException | DateTimeException nfe) {
            return null;
        }
    }

    public static Timestamp decimalToTimestamp(HiveDecimalWritable decWritable, HiveDecimalWritable scratchDecWritable1, HiveDecimalWritable scratchDecWritable2) {
        HiveDecimalWritable nanosWritable = scratchDecWritable1;
        nanosWritable.set(decWritable);
        nanosWritable.mutateFractionPortion();
        nanosWritable.mutateScaleByPowerOfTen(9);
        if (!nanosWritable.isSet() || !nanosWritable.isInt()) {
            return null;
        }
        int nanos = nanosWritable.intValue();
        if (nanos < 0) {
            nanos += 1000000000;
        }
        nanosWritable.setFromLong((long)nanos);
        HiveDecimalWritable nanoInstant = scratchDecWritable2;
        nanoInstant.set(decWritable);
        nanoInstant.mutateScaleByPowerOfTen(9);
        nanoInstant.mutateSubtract(nanosWritable);
        nanoInstant.mutateScaleByPowerOfTen(-9);
        if (!nanoInstant.isSet() || !nanoInstant.isLong()) {
            return null;
        }
        long seconds = nanoInstant.longValue();
        return Timestamp.ofEpochSecond(seconds, nanos);
    }

    public static Timestamp decimalToTimestamp(HiveDecimalV1 dec) {
        try {
            BigDecimal nanoInstant = dec.bigDecimalValue().multiply(BILLION_BIG_DECIMAL);
            int nanos = nanoInstant.remainder(BILLION_BIG_DECIMAL).intValue();
            if (nanos < 0) {
                nanos += 1000000000;
            }
            long seconds = nanoInstant.subtract(new BigDecimal(nanos)).divide(BILLION_BIG_DECIMAL).longValue();
            return Timestamp.ofEpochSecond(seconds, nanos);
        }
        catch (IllegalArgumentException | DateTimeException nfe) {
            return null;
        }
    }

    public static long millisToSeconds(long millis) {
        if (millis >= 0L) {
            return millis / 1000L;
        }
        return (millis - 999L) / 1000L;
    }

    public static Timestamp stringToTimestamp(String text) {
        String s = Objects.requireNonNull(text).trim();
        if (s.length() == DATE_LENGTH) {
            Date d = DateParser.parseDate(s);
            if (d == null) {
                throw new IllegalArgumentException("Cannot parse date: " + text);
            }
            return Timestamp.ofEpochMilli(d.toEpochMilli());
        }
        try {
            return Timestamp.valueOf(s);
        }
        catch (IllegalArgumentException eT) {
            try {
                return Timestamp.valueOf(TimestampTZUtil.parse(s).getZonedDateTime().toLocalDateTime().toString());
            }
            catch (IllegalArgumentException | DateTimeException eTZ) {
                try {
                    return Timestamp.getTimestampFromTime(s);
                }
                catch (DateTimeException e) {
                    return Timestamp.ofEpochMilli(Date.valueOf(s).toEpochMilli());
                }
            }
        }
    }
}

