/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.util.List;
import org.apache.hive.iceberg.org.apache.orc.TypeDescription;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.orc.OrcSchemaVisitor;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class ApplyNameMapping
extends OrcSchemaVisitor<TypeDescription> {
    private final NameMapping nameMapping;

    ApplyNameMapping(NameMapping nameMapping) {
        this.nameMapping = nameMapping;
    }

    @Override
    public String elementName() {
        return "element";
    }

    @Override
    public String keyName() {
        return "key";
    }

    @Override
    public String valueName() {
        return "value";
    }

    TypeDescription setId(TypeDescription type, MappedField mappedField) {
        if (mappedField != null) {
            type.setAttribute("iceberg.id", mappedField.id().toString());
        }
        return type;
    }

    @Override
    public TypeDescription record(TypeDescription record, List<String> names, List<TypeDescription> fields) {
        Preconditions.checkArgument(names.size() == fields.size(), "All fields must have names");
        MappedField field = this.nameMapping.find(this.currentPath());
        TypeDescription structType = TypeDescription.createStruct();
        for (int i = 0; i < fields.size(); ++i) {
            String fieldName = names.get(i);
            TypeDescription fieldType = fields.get(i);
            if (fieldType == null) continue;
            structType.addField(fieldName, fieldType);
        }
        return this.setId(structType, field);
    }

    @Override
    public TypeDescription list(TypeDescription array, TypeDescription element) {
        Preconditions.checkArgument(element != null, "List type must have element type");
        MappedField field = this.nameMapping.find(this.currentPath());
        TypeDescription listType = TypeDescription.createList(element);
        return this.setId(listType, field);
    }

    @Override
    public TypeDescription map(TypeDescription map, TypeDescription key, TypeDescription value) {
        Preconditions.checkArgument(key != null && value != null, "Map type must have both key and value types");
        MappedField field = this.nameMapping.find(this.currentPath());
        TypeDescription mapType = TypeDescription.createMap(key, value);
        return this.setId(mapType, field);
    }

    @Override
    public TypeDescription variant(TypeDescription variant, TypeDescription metadata, TypeDescription value) {
        MappedField field = this.nameMapping.find(this.currentPath());
        return this.setId(variant.clone(), field);
    }

    @Override
    public TypeDescription primitive(TypeDescription primitive) {
        MappedField field = this.nameMapping.find(this.currentPath());
        return this.setId(primitive.clone(), field);
    }
}

