/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.hop.neo4j.transforms.cypher;

import org.apache.hop.pipeline.transform.TransformSerializationTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CypherMetaTest {

  @Test
  void testSerialization() throws Exception {
    CypherMeta meta =
        TransformSerializationTestUtil.testSerialization("/cypher-transform.xml", CypherMeta.class);

    Assertions.assertEquals("Test", meta.getConnectionName());
    Assertions.assertEquals(1, meta.getParameterMappings().size());
  }

  @Test
  void testSerialization2() throws Exception {
    CypherMeta meta =
        TransformSerializationTestUtil.testSerialization(
            "/cypher-transform2.xml", CypherMeta.class);

    Assertions.assertEquals(1, meta.getReturnValues().size());
  }
}
