/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.io.netty.handler.ssl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.ignite.shaded.io.netty.handler.ssl.CipherSuiteFilter;
import org.apache.ignite.shaded.io.netty.util.internal.EmptyArrays;
import org.apache.ignite.shaded.io.netty.util.internal.ObjectUtil;

public final class SupportedCipherSuiteFilter
implements CipherSuiteFilter {
    public static final SupportedCipherSuiteFilter INSTANCE = new SupportedCipherSuiteFilter();

    private SupportedCipherSuiteFilter() {
    }

    @Override
    public String[] filterCipherSuites(Iterable<String> ciphers, List<String> defaultCiphers, Set<String> supportedCiphers) {
        ArrayList<String> newCiphers;
        ObjectUtil.checkNotNull(defaultCiphers, "defaultCiphers");
        ObjectUtil.checkNotNull(supportedCiphers, "supportedCiphers");
        if (ciphers == null) {
            newCiphers = new ArrayList<String>(defaultCiphers.size());
            ciphers = defaultCiphers;
        } else {
            newCiphers = new ArrayList(supportedCiphers.size());
        }
        for (String c : ciphers) {
            if (c == null) break;
            if (!supportedCiphers.contains(c)) continue;
            newCiphers.add(c);
        }
        return newCiphers.toArray(EmptyArrays.EMPTY_STRINGS);
    }
}

