/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event;

import java.util.Objects;
import org.apache.ignite.shaded.org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.shaded.org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.ClientMessage;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.JdbcStatementType;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcObservableTimeAwareRequest;
import org.apache.ignite.shaded.org.apache.ignite.internal.tostring.S;

public class JdbcQueryExecuteRequest
extends JdbcObservableTimeAwareRequest
implements ClientMessage {
    private JdbcStatementType stmtType;
    private String schemaName;
    private int pageSize;
    private int maxRows;
    private String sqlQry;
    private Object[] args;
    private boolean autoCommit;
    private boolean multiStatement;
    private long queryTimeoutMillis;
    private long correlationToken;
    private long observableTime;

    public JdbcQueryExecuteRequest() {
    }

    public JdbcQueryExecuteRequest(JdbcStatementType stmtType, String schemaName, int pageSize, int maxRows, String sqlQry, Object[] args, boolean autoCommit, boolean multiStatement, long queryTimeoutMillis, long correlationToken, long observableTime) {
        Objects.requireNonNull(stmtType);
        this.autoCommit = autoCommit;
        this.stmtType = stmtType;
        this.schemaName = schemaName == null || schemaName.isEmpty() ? null : schemaName;
        this.pageSize = pageSize;
        this.maxRows = maxRows;
        this.sqlQry = sqlQry;
        this.args = args;
        this.multiStatement = multiStatement;
        this.queryTimeoutMillis = queryTimeoutMillis;
        this.correlationToken = correlationToken;
        this.observableTime = observableTime;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public int maxRows() {
        return this.maxRows;
    }

    public boolean multiStatement() {
        return this.multiStatement;
    }

    public String sqlQuery() {
        return this.sqlQry;
    }

    public Object[] arguments() {
        return this.args;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public JdbcStatementType getStmtType() {
        return this.stmtType;
    }

    public boolean autoCommit() {
        return this.autoCommit;
    }

    public long queryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    public long correlationToken() {
        return this.correlationToken;
    }

    public long observableTime() {
        return this.observableTime;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        packer.packBoolean(this.autoCommit);
        packer.packByte(this.stmtType.getId());
        packer.packString(this.schemaName);
        packer.packInt(this.pageSize);
        packer.packInt(this.maxRows);
        packer.packString(this.sqlQry);
        packer.packBoolean(this.multiStatement);
        packer.packObjectArrayAsBinaryTuple(this.args);
        packer.packLong(this.queryTimeoutMillis);
        packer.packLong(this.correlationToken);
        packer.packLong(this.observableTime);
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        this.autoCommit = unpacker.unpackBoolean();
        this.stmtType = JdbcStatementType.getStatement(unpacker.unpackByte());
        this.schemaName = unpacker.unpackString();
        this.pageSize = unpacker.unpackInt();
        this.maxRows = unpacker.unpackInt();
        this.sqlQry = unpacker.unpackString();
        this.multiStatement = unpacker.unpackBoolean();
        this.args = unpacker.unpackObjectArrayFromBinaryTuple();
        this.queryTimeoutMillis = unpacker.unpackLong();
        this.correlationToken = unpacker.unpackLong();
        this.observableTime = unpacker.unpackLong();
    }

    public String toString() {
        return S.toString(JdbcQueryExecuteRequest.class, this);
    }
}

