/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.sql;

import java.util.List;
import org.apache.ignite.shaded.org.apache.ignite.internal.tostring.S;
import org.apache.ignite.shaded.org.apache.ignite.sql.ColumnMetadata;
import org.apache.ignite.shaded.org.apache.ignite.sql.ColumnType;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public class ColumnMetadataImpl
implements ColumnMetadata {
    private final String name;
    private final ColumnType type;
    private final int precision;
    private final int scale;
    private final boolean nullable;
    private final ColumnMetadata.ColumnOrigin origin;

    @Nullable
    public static ColumnMetadata.ColumnOrigin originFromList(@Nullable List<String> origin) {
        if (origin == null) {
            return null;
        }
        String schemaName = origin.isEmpty() ? "" : origin.get(0);
        String tableName = origin.size() < 2 ? "" : origin.get(1);
        String columnName = origin.size() < 3 ? "" : origin.get(2);
        return new ColumnOriginImpl(schemaName, tableName, columnName);
    }

    public ColumnMetadataImpl(String name, ColumnType type, int precision, int scale, boolean nullable, @Nullable ColumnMetadata.ColumnOrigin origin) {
        this.name = name;
        this.type = type;
        this.precision = precision;
        this.scale = scale;
        this.nullable = nullable;
        this.origin = origin;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ColumnType type() {
        return this.type;
    }

    @Override
    public int precision() {
        return this.precision;
    }

    @Override
    public int scale() {
        return this.scale;
    }

    @Override
    public Class<?> valueClass() {
        return this.type.javaClass();
    }

    @Override
    public boolean nullable() {
        return this.nullable;
    }

    @Override
    public ColumnMetadata.ColumnOrigin origin() {
        return this.origin;
    }

    public String toString() {
        return S.toString(ColumnMetadataImpl.class, this);
    }

    public static class ColumnOriginImpl
    implements ColumnMetadata.ColumnOrigin {
        private final String schemaName;
        private final String tableName;
        private final String columnName;

        public ColumnOriginImpl(String schemaName, String tableName, String columnName) {
            this.schemaName = schemaName;
            this.tableName = tableName;
            this.columnName = columnName;
        }

        @Override
        public String schemaName() {
            return this.schemaName;
        }

        @Override
        public String tableName() {
            return this.tableName;
        }

        @Override
        public String columnName() {
            return this.columnName;
        }

        public String toString() {
            return S.toString(ColumnOriginImpl.class, this);
        }
    }
}

