/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv.io;

import org.apache.ignite.internal.lang.IgniteStringBuilder;
import org.apache.ignite.internal.pagememory.io.IoVersions;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.util.PageUtils;

public class BlobFragmentIo
extends PageIo {
    private static final int NEXT_PAGE_ID_OFF = 40;
    private static final int FRAGMENT_BYTES_OR_TOTAL_LENGTH_OFF = 48;
    public static final IoVersions<BlobFragmentIo> VERSIONS = new IoVersions((PageIo[])new BlobFragmentIo[]{new BlobFragmentIo(1)});

    private BlobFragmentIo(int ver) {
        super(12, ver, (byte)2);
    }

    public void initNewPage(long pageAddr, long pageId, int pageSize) {
        super.initNewPage(pageAddr, pageId, pageSize);
        this.setNextPageId(pageAddr, 0L);
    }

    public int getCapacityForFragmentBytes(int pageSize, boolean firstPage) {
        return pageSize - BlobFragmentIo.fragmentBytesOffset(firstPage);
    }

    public long getNextPageId(long pageAddr) {
        return PageUtils.getLong((long)pageAddr, (int)40);
    }

    public void setNextPageId(long pageAddr, long nextPageId) {
        PageUtils.putLong((long)pageAddr, (int)40, (long)nextPageId);
    }

    public int getTotalLength(long pageAddr) {
        return PageUtils.getInt((long)pageAddr, (int)48);
    }

    public void setTotalLength(long pageAddr, int totalLength) {
        PageUtils.putInt((long)pageAddr, (int)48, (int)totalLength);
    }

    public void getFragmentBytes(long pageAddr, boolean firstPage, byte[] destArray, int destOffset, int fragmentLength) {
        PageUtils.getBytes((long)pageAddr, (int)BlobFragmentIo.fragmentBytesOffset(firstPage), (byte[])destArray, (int)destOffset, (int)fragmentLength);
    }

    public void setFragmentBytes(long pageAddr, boolean firstPage, byte[] bytes, int bytesOffset, int fragmentLength) {
        PageUtils.putBytes((long)pageAddr, (int)BlobFragmentIo.fragmentBytesOffset(firstPage), (byte[])bytes, (int)bytesOffset, (int)fragmentLength);
    }

    private static int fragmentBytesOffset(boolean firstPage) {
        return 48 + (firstPage ? 4 : 0);
    }

    protected void printPage(long addr, int pageSize, IgniteStringBuilder sb) {
        sb.app("BlobFragmentIo [").nl().app("nextPageId=").app(this.getNextPageId(addr)).nl().app(']');
    }
}

