/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.odbc;

import java.util.List;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.internal.processors.cache.query.QueryCursorEx;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcResultSet;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcUtils;

public class OdbcQueryResults {
    private final List<FieldsQueryCursor<List<?>>> cursors;
    private final long[] rowsAffected;
    private OdbcResultSet currentResultSet;
    private int nextResultSetIdx;
    private ClientListenerProtocolVersion ver;

    OdbcQueryResults(List<FieldsQueryCursor<List<?>>> cursors, ClientListenerProtocolVersion ver) {
        this.cursors = cursors;
        this.nextResultSetIdx = 0;
        this.ver = ver;
        this.rowsAffected = new long[cursors.size()];
        for (int i = 0; i < cursors.size(); ++i) {
            this.rowsAffected[i] = OdbcUtils.rowsAffected((QueryCursor)cursors.get(i));
        }
        this.nextResultSet();
    }

    public long[] rowsAffected() {
        return this.rowsAffected;
    }

    public boolean hasUnfetchedRows() {
        if (this.currentResultSet != null && this.currentResultSet.hasUnfetchedRows()) {
            return true;
        }
        for (FieldsQueryCursor<List<?>> cursor0 : this.cursors) {
            QueryCursorEx cursor = (QueryCursorEx)((Object)cursor0);
            if (!cursor.isQuery()) continue;
            return true;
        }
        return false;
    }

    public void closeAll() {
        for (FieldsQueryCursor<List<?>> cursor : this.cursors) {
            cursor.close();
        }
    }

    public OdbcResultSet currentResultSet() {
        return this.currentResultSet;
    }

    public void nextResultSet() {
        this.currentResultSet = null;
        if (this.nextResultSetIdx != this.cursors.size()) {
            this.currentResultSet = new OdbcResultSet(this.cursors.get(this.nextResultSetIdx), this.ver);
            ++this.nextResultSetIdx;
        }
    }
}

