/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.state.RocksDBCheckpointMetadata;
import org.apache.spark.sql.execution.streaming.state.RocksDBCheckpointMetadata$;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManager$;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManagerMetrics;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManagerMetrics$;
import org.apache.spark.sql.execution.streaming.state.RocksDBImmutableFile;
import org.apache.spark.sql.execution.streaming.state.RocksDBImmutableFile$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\tub\u0001B\u0015+\u0001eB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"A1\f\u0001B\u0001B\u0003%A\f\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003H\u0011\u0015)\u0007\u0001\"\u0001g\u0011\u001di\u0007A1A\u0005\n9Dq!!\u0004\u0001A\u0003%q\u000e\u0003\u0006\u0002\u0010\u0001A)\u0019!C\u0005\u0003#A\u0011\"a\u0007\u0001\u0005\u0004%I!!\b\t\u0011\u0005%\u0002\u0001)A\u0005\u0003?A\u0011\"a\u000b\u0001\u0005\u0004%I!!\f\t\u0011\u0005U\u0002\u0001)A\u0005\u0003_A\u0011\"!\u0013\u0001\u0001\u0004%I!a\u0013\t\u0013\u0005M\u0003\u00011A\u0005\n\u0005U\u0003\u0002CA1\u0001\u0001\u0006K!!\u0014\t\u0013\u0005-\u0004\u00011A\u0005\n\u0005-\u0003\"CA7\u0001\u0001\u0007I\u0011BA8\u0011!\t\u0019\b\u0001Q!\n\u00055\u0003bBA<\u0001\u0011\u0005\u00111\n\u0005\b\u0003s\u0002A\u0011AA&\u0011\u001d\tY\b\u0001C\u0001\u0003{Bq!a#\u0001\t\u0003\ti\tC\u0004\u0002\u001c\u0002!\t!!(\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\"\"9\u0011Q\u0016\u0001\u0005\n\u0005=\u0006bBA]\u0001\u0011%\u00111\u0018\u0005\b\u0003\u0007\u0004A\u0011BAc\u0011\u001d\tI\r\u0001C\u0005\u0003\u0017Dq!a7\u0001\t\u0013\ti\u000eC\u0004\u0002h\u0002!I!!;\t\u000f\u0005=\b\u0001\"\u0003\u0002r\"9\u0011Q\u001f\u0001\u0005\n\u0005]\bbBA\u007f\u0001\u0011E\u0013q \u0005\b\u0005\u0003\u0001A\u0011\u0002B\u0002\u0011\u001d\u0011I\u0001\u0001C\u0005\u0005\u0017AqA!\u0005\u0001\t\u0013\u0011\u0019bB\u0005\u0003\u001e)\n\t\u0011#\u0001\u0003 \u0019A\u0011FKA\u0001\u0012\u0003\u0011\t\u0003\u0003\u0004fM\u0011\u0005!1\u0005\u0005\n\u0005K1\u0013\u0013!C\u0001\u0005O\u0011!CU8dWN$%IR5mK6\u000bg.Y4fe*\u00111\u0006L\u0001\u0006gR\fG/\u001a\u0006\u0003[9\n\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005=\u0002\u0014!C3yK\u000e,H/[8o\u0015\t\t$'A\u0002tc2T!a\r\u001b\u0002\u000bM\u0004\u0018M]6\u000b\u0005U2\u0014AB1qC\u000eDWMC\u00018\u0003\ry'oZ\u0002\u0001'\r\u0001!\b\u0011\t\u0003wyj\u0011\u0001\u0010\u0006\u0002{\u0005)1oY1mC&\u0011q\b\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r\u0013\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0015\u0013%a\u0002'pO\u001eLgnZ\u0001\u000bI\u001a\u001c(k\\8u\t&\u0014\bC\u0001%P\u001d\tIU\n\u0005\u0002Ky5\t1J\u0003\u0002Mq\u00051AH]8pizJ!A\u0014\u001f\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0016K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001dr\nA\u0002\\8dC2$V-\u001c9ESJ\u0004\"\u0001V-\u000e\u0003US!AV,\u0002\u0005%|'\"\u0001-\u0002\t)\fg/Y\u0005\u00035V\u0013AAR5mK\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017\u0001B2p]\u001aT!!\u0019\u001b\u0002\r!\fGm\\8q\u0013\t\u0019gLA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\nY><w-\u001b8h\u0013\u0012\fa\u0001P5oSRtD#B4jU.d\u0007C\u00015\u0001\u001b\u0005Q\u0003\"\u0002$\u0006\u0001\u00049\u0005\"\u0002*\u0006\u0001\u0004\u0019\u0006\"B.\u0006\u0001\u0004a\u0006b\u00023\u0006!\u0003\u0005\raR\u0001\u0016m\u0016\u00148/[8o)>\u0014vnY6t\t\n3\u0015\u000e\\3t+\u0005y\u0007\u0003\u00029vojl\u0011!\u001d\u0006\u0003eN\f!bY8oGV\u0014(/\u001a8u\u0015\t!x+\u0001\u0003vi&d\u0017B\u0001<r\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0003waL!!\u001f\u001f\u0003\t1{gn\u001a\t\u0006w\u0006\u0005\u0011q\u0001\b\u0003yzt!AS?\n\u0003uJ!a \u001f\u0002\u000fA\f7m[1hK&!\u00111AA\u0003\u0005\r\u0019V-\u001d\u0006\u0003\u007fr\u00022\u0001[A\u0005\u0013\r\tYA\u000b\u0002\u0015%>\u001c7n\u001d#C\u00136lW\u000f^1cY\u00164\u0015\u000e\\3\u0002-Y,'o]5p]R{'k\\2lg\u0012\u0013e)\u001b7fg\u0002\n!AZ7\u0016\u0005\u0005M\u0001\u0003BA\u000b\u0003/i\u0011\u0001L\u0005\u0004\u00033a#!F\"iK\u000e\\\u0007o\\5oi\u001aKG.Z'b]\u0006<WM]\u0001\u0003MN,\"!a\b\u0011\t\u0005\u0005\u0012QE\u0007\u0003\u0003GQ1!a\u0007a\u0013\u0011\t9#a\t\u0003\u0015\u0019KG.Z*zgR,W.A\u0002gg\u0002\nAb\u001c8msjK\u0007OR5mKN,\"!a\f\u0013\r\u0005E\u0012qGA\"\r\u0019\t\u0019\u0004\u0004\u0001\u00020\taAH]3gS:,W.\u001a8u}\u0005iqN\u001c7z5&\u0004h)\u001b7fg\u0002\u0002B!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{9\u0016\u0001\u00027b]\u001eLA!!\u0011\u0002<\t1qJ\u00196fGR\u0004B!!\t\u0002F%!\u0011qIA\u0012\u0005)\u0001\u0016\r\u001e5GS2$XM]\u0001\u0016Y>\fGm\u00115fG.\u0004x.\u001b8u\u001b\u0016$(/[2t+\t\ti\u0005E\u0002i\u0003\u001fJ1!!\u0015+\u0005e\u0011vnY6t\t\n3\u0015\u000e\\3NC:\fw-\u001a:NKR\u0014\u0018nY:\u000231|\u0017\rZ\"iK\u000e\\\u0007o\\5oi6+GO]5dg~#S-\u001d\u000b\u0005\u0003/\ni\u0006E\u0002<\u00033J1!a\u0017=\u0005\u0011)f.\u001b;\t\u0013\u0005}c\"!AA\u0002\u00055\u0013a\u0001=%c\u00051Bn\\1e\u0007\",7m\u001b9pS:$X*\u001a;sS\u000e\u001c\b\u0005K\u0002\u0010\u0003K\u00022aOA4\u0013\r\tI\u0007\u0010\u0002\tm>d\u0017\r^5mK\u0006)2/\u0019<f\u0007\",7m\u001b9pS:$X*\u001a;sS\u000e\u001c\u0018!G:bm\u0016\u001c\u0005.Z2la>Lg\u000e^'fiJL7m]0%KF$B!a\u0016\u0002r!I\u0011qL\t\u0002\u0002\u0003\u0007\u0011QJ\u0001\u0017g\u00064Xm\u00115fG.\u0004x.\u001b8u\u001b\u0016$(/[2tA!\u001a!#!\u001a\u000271\fG/Z:u\u0019>\fGm\u00115fG.\u0004x.\u001b8u\u001b\u0016$(/[2t\u0003ma\u0017\r^3tiN\u000bg/Z\"iK\u000e\\\u0007o\\5oi6+GO]5dg\u0006\u00192/\u0019<f\u0007\",7m\u001b9pS:$Hk\u001c#ggRA\u0011qKA@\u0003\u0007\u000b9\t\u0003\u0004\u0002\u0002V\u0001\raU\u0001\u000eG\",7m\u001b9pS:$H)\u001b:\t\r\u0005\u0015U\u00031\u0001x\u0003\u001d1XM]:j_:Da!!#\u0016\u0001\u00049\u0018a\u00028v[.+\u0017p]\u0001\u0016Y>\fGm\u00115fG.\u0004x.\u001b8u\rJ|W\u000e\u00124t)\u0019\ty)!&\u0002\u0018B\u0019\u0001.!%\n\u0007\u0005M%FA\rS_\u000e\\7\u000f\u0012\"DQ\u0016\u001c7\u000e]8j]RlU\r^1eCR\f\u0007BBAC-\u0001\u0007q\u000f\u0003\u0004\u0002\u001aZ\u0001\raU\u0001\tY>\u001c\u0017\r\u001c#je\u0006\u0001r-\u001a;MCR,7\u000f\u001e,feNLwN\u001c\u000b\u0002o\u0006\tB-\u001a7fi\u0016|E\u000e\u001a,feNLwN\\:\u0015\t\u0005]\u00131\u0015\u0005\b\u0003KC\u0002\u0019AAT\u0003MqW/\u001c,feNLwN\\:U_J+G/Y5o!\rY\u0014\u0011V\u0005\u0004\u0003Wc$aA%oi\u000692/\u0019<f\u00136lW\u000f^1cY\u00164\u0015\u000e\\3t)>$em\u001d\u000b\u0006u\u0006E\u00161\u0017\u0005\u0007\u0003\u000bK\u0002\u0019A<\t\u000f\u0005U\u0016\u00041\u0001\u00028\u0006QAn\\2bY\u001aKG.Z:\u0011\tm\f\taU\u0001\u001aY>\fG-S7nkR\f'\r\\3GS2,7O\u0012:p[\u001237\u000f\u0006\u0004\u0002X\u0005u\u0016\u0011\u0019\u0005\u0007\u0003\u007fS\u0002\u0019\u0001>\u0002\u001d%lW.\u001e;bE2,g)\u001b7fg\"1\u0011\u0011\u0014\u000eA\u0002M\u000bqdZ3u\u00136lW\u000f^1cY\u00164\u0015\u000e\\3t\rJ|WNV3sg&|gNW5q)\rQ\u0018q\u0019\u0005\u0007\u0003\u000b[\u0002\u0019A<\u0002\u0019iL\u0007\u000fV8EMN4\u0015\u000e\\3\u0015\r\u0005]\u0013QZAi\u0011\u001d\ty\r\ba\u0001\u0003o\u000bQAZ5mKNDq!a5\u001d\u0001\u0004\t).\u0001\u0006eMNT\u0016\u000e\u001d$jY\u0016\u0004B!!\t\u0002X&!\u0011\u0011\\A\u0012\u0005\u0011\u0001\u0016\r\u001e5\u0002\u001b1|wMR5mKNLe\u000eR5s)\u0019\t9&a8\u0002d\"1\u0011\u0011]\u000fA\u0002M\u000b1\u0001Z5s\u0011\u0019\t)/\ba\u0001\u000f\u0006\u0019Qn]4\u0002\u001d9,w\u000f\u0012$T\r&dWMT1nKR\u0019q)a;\t\r\u00055h\u00041\u0001H\u00035awnY1m\r&dWMT1nK\u0006yAMZ:CCR\u001c\u0007NW5q\r&dW\r\u0006\u0003\u0002V\u0006M\bBBAC?\u0001\u0007q/A\tm_\u000e\fG.T3uC\u0012\fG/\u0019$jY\u0016$2aUA}\u0011\u0019\tY\u0010\ta\u0001'\u0006I\u0001/\u0019:f]R$\u0015N]\u0001\bY><g*Y7f+\u00059\u0015a\u00033gg\u001aKG.\u001a)bi\"$B!!6\u0003\u0006!1!q\u0001\u0012A\u0002\u001d\u000b\u0001BZ5mK:\u000bW.Z\u0001\u000eY>\u001c\u0017\r\u001c$jY\u0016\u0004\u0016\r\u001e5\u0015\u000bM\u0013iAa\u0004\t\r\u0005e5\u00051\u0001T\u0011\u0019\u00119a\ta\u0001\u000f\u0006\u0001B.[:u%>\u001c7n\u001d#C\r&dWm\u001d\u000b\u0005\u0005+\u0011Y\u0002E\u0004<\u0005/\t9,a.\n\u0007\teAH\u0001\u0004UkBdWM\r\u0005\u0007\u00033#\u0003\u0019A*\u0002%I{7m[:E\u0005\u001aKG.Z'b]\u0006<WM\u001d\t\u0003Q\u001a\u001a\"A\n\u001e\u0015\u0005\t}\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0003*)\u001aqIa\u000b,\u0005\t5\u0002\u0003\u0002B\u0018\u0005si!A!\r\u000b\t\tM\"QG\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u000e=\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005w\u0011\tDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class RocksDBFileManager
implements Logging {
    private CheckpointFileManager fm;
    private final String dfsRootDir;
    private final File localTempDir;
    private Configuration hadoopConf;
    private final String loggingId;
    private final ConcurrentHashMap<Object, Seq<RocksDBImmutableFile>> versionToRocksDBFiles;
    private final FileSystem fs;
    private final PathFilter onlyZipFiles;
    private volatile RocksDBFileManagerMetrics loadCheckpointMetrics;
    private volatile RocksDBFileManagerMetrics saveCheckpointMetrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$4() {
        return RocksDBFileManager$.MODULE$.$lessinit$greater$default$4();
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentHashMap<Object, Seq<RocksDBImmutableFile>> versionToRocksDBFiles() {
        return this.versionToRocksDBFiles;
    }

    private CheckpointFileManager fm$lzycompute() {
        RocksDBFileManager rocksDBFileManager = this;
        synchronized (rocksDBFileManager) {
            if (!this.bitmap$0) {
                this.fm = CheckpointFileManager$.MODULE$.create(new Path(this.dfsRootDir), this.hadoopConf);
                this.bitmap$0 = true;
            }
        }
        this.hadoopConf = null;
        return this.fm;
    }

    private CheckpointFileManager fm() {
        return !this.bitmap$0 ? this.fm$lzycompute() : this.fm;
    }

    private FileSystem fs() {
        return this.fs;
    }

    private PathFilter onlyZipFiles() {
        return this.onlyZipFiles;
    }

    private RocksDBFileManagerMetrics loadCheckpointMetrics() {
        return this.loadCheckpointMetrics;
    }

    private void loadCheckpointMetrics_$eq(RocksDBFileManagerMetrics x$1) {
        this.loadCheckpointMetrics = x$1;
    }

    private RocksDBFileManagerMetrics saveCheckpointMetrics() {
        return this.saveCheckpointMetrics;
    }

    private void saveCheckpointMetrics_$eq(RocksDBFileManagerMetrics x$1) {
        this.saveCheckpointMetrics = x$1;
    }

    public RocksDBFileManagerMetrics latestLoadCheckpointMetrics() {
        return this.loadCheckpointMetrics();
    }

    public RocksDBFileManagerMetrics latestSaveCheckpointMetrics() {
        return this.saveCheckpointMetrics();
    }

    public void saveCheckpointToDfs(File checkpointDir, long version, long numKeys) {
        this.logFilesInDir(checkpointDir, new StringBuilder(36).append("Saving checkpoint files for version ").append(version).toString());
        Tuple2<Seq<File>, Seq<File>> tuple2 = this.listRocksDBFiles(checkpointDir);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq localImmutableFiles = (Seq)tuple2._1();
        Seq localOtherFiles = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)localImmutableFiles, (Object)localOtherFiles);
        Tuple2 tuple23 = tuple22;
        Seq localImmutableFiles2 = (Seq)tuple23._1();
        Seq localOtherFiles2 = (Seq)tuple23._2();
        Seq<RocksDBImmutableFile> rocksDBFiles = this.saveImmutableFilesToDfs(version, (Seq<File>)localImmutableFiles2);
        RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.apply(rocksDBFiles, numKeys);
        File metadataFile = this.localMetadataFile(checkpointDir);
        metadata.writeToFile(metadataFile);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Written metadata for version ").append(version).append(":\n").append(metadata.prettyJson()).toString());
        if (version <= 1L && numKeys <= 0L) {
            Path path = new Path(this.dfsRootDir);
            if (!this.fm().exists(path)) {
                this.fm().mkdirs(path);
            }
        }
        this.zipToDfsFile((Seq<File>)((Seq)localOtherFiles2.$colon$plus((Object)metadataFile, Seq$.MODULE$.canBuildFrom())), this.dfsBatchZipFile(version));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Saved checkpoint file for version ").append(version).toString());
    }

    public RocksDBCheckpointMetadata loadCheckpointFromDfs(long version, File localDir) {
        RocksDBCheckpointMetadata rocksDBCheckpointMetadata;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Loading checkpoint files for version ").append(version).toString());
        if (version == 0L) {
            if (localDir.exists()) {
                Utils$.MODULE$.deleteRecursively(localDir);
            }
            localDir.mkdirs();
            rocksDBCheckpointMetadata = RocksDBCheckpointMetadata$.MODULE$.apply((Seq<RocksDBImmutableFile>)((Seq)Nil$.MODULE$), 0L);
        } else {
            ((IterableLike)this.listRocksDBFiles(localDir)._2()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.delete()));
            Utils$.MODULE$.unzipFilesFromFile(this.fs(), this.dfsBatchZipFile(version), localDir);
            File metadataFile = this.localMetadataFile(localDir);
            RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.readFromFile(metadataFile);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Read metadata for version ").append(version).append(":\n").append(metadata.prettyJson()).toString());
            this.loadImmutableFilesFromDfs(metadata.immutableFiles(), localDir);
            this.versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), metadata.immutableFiles());
            metadataFile.delete();
            rocksDBCheckpointMetadata = metadata;
        }
        RocksDBCheckpointMetadata metadata = rocksDBCheckpointMetadata;
        this.logFilesInDir(localDir, new StringBuilder(36).append("Loaded checkpoint files for version ").append(version).toString());
        return metadata;
    }

    public long getLatestVersion() {
        Path path = new Path(this.dfsRootDir);
        return this.fm().exists(path) ? BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(path, this.onlyZipFiles()))).map((Function1 & Serializable & scala.Serializable)x$3 -> new StringOps(Predef$.MODULE$.augmentString(x$3.getPath().getName())).stripSuffix(".zip"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)RocksDBFileManager.$anonfun$getLatestVersion$2(x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x, y) -> package$.MODULE$.max(x, y))) : 0L;
    }

    public void deleteOldVersions(int numVersionsToRetain) {
        Path path = new Path(this.dfsRootDir);
        long[] sortedVersions = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(path, this.onlyZipFiles()))).map((Function1 & Serializable & scala.Serializable)x$5 -> new StringOps(Predef$.MODULE$.augmentString(x$5.getPath().getName())).stripSuffix(".zip"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)RocksDBFileManager.$anonfun$deleteOldVersions$2(x$6)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sorted((Ordering)Ordering.Long$.MODULE$);
        if (new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sortedVersions)).isEmpty()) {
            return;
        }
        long maxVersionPresent = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sortedVersions)).last());
        long minVersionPresent = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sortedVersions)).head());
        long minVersionToRetain = package$.MODULE$.max(minVersionPresent, maxVersionPresent - (long)numVersionsToRetain + 1L);
        Set versionsToDelete = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sortedVersions)).takeWhile((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$7 -> x$7 < minVersionToRetain))).toSet();
        if (versionsToDelete.isEmpty()) {
            return;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Versions present: (min ").append(minVersionPresent).append(", max ").append(maxVersionPresent).append("), ").append("cleaning up all versions older than ").append(minVersionToRetain).append(" to retain last ").append(numVersionsToRetain).append(" versions").toString());
        HashMap fileToMaxUsedVersion = new HashMap();
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sortedVersions)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)version -> {
            Seq files = (Seq)Option$.MODULE$.apply(this.versionToRocksDBFiles().get(BoxesRunTime.boxToLong((long)version))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                void var3_2;
                Seq<RocksDBImmutableFile> newResolvedFiles = this.getImmutableFilesFromVersionZip(version);
                this.versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), newResolvedFiles);
                return var3_2;
            });
            files.foreach((Function1 & Serializable & scala.Serializable)f -> {
                fileToMaxUsedVersion.update((Object)f, (Object)BoxesRunTime.boxToLong((long)version));
                return BoxedUnit.UNIT;
            });
        });
        HashMap filesToDelete = (HashMap)fileToMaxUsedVersion.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$deleteOldVersions$8(versionsToDelete, x0$1)));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Deleting ").append(filesToDelete.size()).append(" files not used in versions >= ").append(minVersionToRetain).toString());
        IntRef failedToDelete = IntRef.create((int)0);
        filesToDelete.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            RocksDBFileManager.$anonfun$deleteOldVersions$10(this, failedToDelete, x0$2);
            return BoxedUnit.UNIT;
        });
        versionsToDelete.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)version -> {
            Path versionFile = this.dfsBatchZipFile(version);
            try {
                this.fm().delete(versionFile);
                this.versionToRocksDBFiles().remove(BoxesRunTime.boxToLong((long)version));
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Deleted version ").append(version).toString());
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Error deleting version file ").append(versionFile).append(" for version ").append(version).toString(), e);
            }
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Deleted ").append(filesToDelete.size() - failedToDelete$1.elem).append(" files (failed to delete").append(failedToDelete$1.elem).append(" files) not used in versions >= ").append(minVersionToRetain).toString());
    }

    private Seq<RocksDBImmutableFile> saveImmutableFilesToDfs(long version, Seq<File> localFiles) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Saving RocksDB files to DFS for ").append(version).toString());
        Map prevFilesToSizes = ((TraversableOnce)((TraversableLike)((GenericTraversableTemplate)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.versionToRocksDBFiles().values()).asScala()).flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.localFileName()), f), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        LongRef bytesCopied = LongRef.create((long)0L);
        LongRef filesCopied = LongRef.create((long)0L);
        LongRef filesReused = LongRef.create((long)0L);
        Seq immutableFiles = (Seq)localFiles.map((Function1 & Serializable & scala.Serializable)localFile -> (RocksDBImmutableFile)prevFilesToSizes.get((Object)localFile.getName()).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isSameFile(localFile))).map((Function1 & Serializable & scala.Serializable)reusable -> {
            ++filesReused$1.elem;
            return reusable;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String localFileName = localFile.getName();
            String dfsFileName = this.newDFSFileName(localFileName);
            Path dfsFile = this.dfsFilePath(dfsFileName);
            this.fs().copyFromLocalFile(new Path(localFile.getAbsoluteFile().toURI()), dfsFile);
            long localFileSize = localFile.length();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Copied ").append(localFile).append(" to ").append(dfsFile).append(" - ").append(localFileSize).append(" bytes").toString());
            ++filesCopied$1.elem;
            bytesCopied$1.elem += localFileSize;
            return RocksDBImmutableFile$.MODULE$.apply(localFile.getName(), dfsFileName, localFileSize);
        }), Seq$.MODULE$.canBuildFrom());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Copied ").append(filesCopied$1.elem).append(" files (").append(bytesCopied$1.elem).append(" bytes) from local to").append(" DFS for version ").append(version).append(". ").append(filesReused$1.elem).append(" files reused without copying.").toString());
        this.versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), (Seq<RocksDBImmutableFile>)immutableFiles);
        long x$1 = bytesCopied.elem;
        long x$2 = filesCopied.elem;
        long x$3 = filesReused.elem;
        Option<Object> x$4 = RocksDBFileManagerMetrics$.MODULE$.apply$default$4();
        this.saveCheckpointMetrics_$eq(new RocksDBFileManagerMetrics(x$2, x$1, x$3, x$4));
        return immutableFiles;
    }

    private void loadImmutableFilesFromDfs(Seq<RocksDBImmutableFile> immutableFiles, File localDir) {
        Map requiredFileNameToFileDetails = ((TraversableOnce)immutableFiles.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.localFileName()), f), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        ((IterableLike)this.listRocksDBFiles(localDir)._1()).foreach((Function1 & Serializable & scala.Serializable)existingFile -> {
            RocksDBFileManager.$anonfun$loadImmutableFilesFromDfs$2(this, requiredFileNameToFileDetails, existingFile);
            return BoxedUnit.UNIT;
        });
        LongRef filesCopied = LongRef.create((long)0L);
        LongRef bytesCopied = LongRef.create((long)0L);
        LongRef filesReused = LongRef.create((long)0L);
        immutableFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
            RocksDBFileManager.$anonfun$loadImmutableFilesFromDfs$5(this, localDir, filesCopied, bytesCopied, filesReused, file);
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Copied ").append(filesCopied$2.elem).append(" files (").append(bytesCopied$2.elem).append(" bytes) from DFS to local with ").append(filesReused$2.elem).append(" files reused.").toString());
        long x$1 = bytesCopied.elem;
        long x$2 = filesCopied.elem;
        long x$3 = filesReused.elem;
        Option<Object> x$4 = RocksDBFileManagerMetrics$.MODULE$.apply$default$4();
        this.loadCheckpointMetrics_$eq(new RocksDBFileManagerMetrics(x$2, x$1, x$3, x$4));
    }

    private Seq<RocksDBImmutableFile> getImmutableFilesFromVersionZip(long version) {
        Utils$.MODULE$.deleteRecursively(this.localTempDir);
        this.localTempDir.mkdirs();
        Utils$.MODULE$.unzipFilesFromFile(this.fs(), this.dfsBatchZipFile(version), this.localTempDir);
        File metadataFile = this.localMetadataFile(this.localTempDir);
        RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.readFromFile(metadataFile);
        return metadata.immutableFiles();
    }

    private void zipToDfsFile(Seq<File> files, Path dfsZipFile) {
        LazyRef filesStr$lzy = new LazyRef();
        ObjectRef in = ObjectRef.create(null);
        CheckpointFileManager.CancellableFSDataOutputStream out = this.fm().createAtomic(dfsZipFile, true);
        LongRef totalBytes = LongRef.create((long)0L);
        ZipOutputStream zout = new ZipOutputStream((OutputStream)((Object)out));
        try {
            try {
                files.foreach((Function1 & Serializable & scala.Serializable)file -> {
                    RocksDBFileManager.$anonfun$zipToDfsFile$1(zout, in, totalBytes, file);
                    return BoxedUnit.UNIT;
                });
                zout.close();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Zipped ").append(totalBytes$1.elem).append(" bytes (before compression) to ").append(RocksDBFileManager.filesStr$1(filesStr$lzy, dfsZipFile, files)).toString());
                RocksDBFileManagerMetrics qual$1 = this.saveCheckpointMetrics();
                Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)totalBytes.elem));
                long x$2 = qual$1.copy$default$1();
                long x$3 = qual$1.copy$default$2();
                long x$4 = qual$1.copy$default$3();
                this.saveCheckpointMetrics_$eq(qual$1.copy(x$2, x$3, x$4, (Option<Object>)x$1));
            }
            catch (Exception e) {
                out.cancel();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Error zipping to ").append(RocksDBFileManager.filesStr$1(filesStr$lzy, dfsZipFile, files)).toString(), e);
                throw e;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)((InputStream)in.elem));
            IOUtils.closeQuietly((OutputStream)zout);
        }
    }

    private void logFilesInDir(File dir, String msg) {
        LazyRef files$lzy = new LazyRef();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append(msg).append(" - ").append(RocksDBFileManager.files$2(files$lzy, dir).length).append(" files\n\t").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RocksDBFileManager.files$2(files$lzy, dir))).mkString("\n\t")).toString());
    }

    private String newDFSFileName(String localFileName) {
        String baseName = FilenameUtils.getBaseName((String)localFileName);
        String extension = FilenameUtils.getExtension((String)localFileName);
        return new StringBuilder(2).append(baseName).append("-").append(UUID.randomUUID()).append(".").append(extension).toString();
    }

    private Path dfsBatchZipFile(long version) {
        return new Path(new StringBuilder(5).append(this.dfsRootDir).append("/").append(version).append(".zip").toString());
    }

    private File localMetadataFile(File parentDir) {
        return new File(parentDir, "metadata");
    }

    public String logName() {
        return new StringBuilder(1).append(Logging.logName$((Logging)this)).append(" ").append(this.loggingId).toString();
    }

    private Path dfsFilePath(String fileName) {
        return RocksDBImmutableFile$.MODULE$.isSstFile(fileName) ? new Path(new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.SST_FILES_DFS_SUBDIR()), fileName) : (RocksDBImmutableFile$.MODULE$.isLogFile(fileName) ? new Path(new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_DFS_SUBDIR()), fileName) : new Path(this.dfsRootDir, fileName));
    }

    private File localFilePath(File localDir, String fileName) {
        return RocksDBImmutableFile$.MODULE$.isLogFile(fileName) ? new File(new File(localDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_LOCAL_SUBDIR()), fileName) : new File(localDir, fileName);
    }

    private Tuple2<Seq<File>, Seq<File>> listRocksDBFiles(File localDir) {
        File[] topLevelFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])localDir.listFiles())).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$listRocksDBFiles$1(x$10)));
        File[] archivedLogFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)new File(localDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_LOCAL_SUBDIR()).listFiles()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class))))).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RocksDBImmutableFile$.MODULE$.isLogFile(file.getName())));
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topLevelFiles)).partition((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)RocksDBImmutableFile$.MODULE$.isSstFile(f.getName())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File[] topLevelSstFiles = (File[])tuple2._1();
        File[] topLevelOtherFiles = (File[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)topLevelSstFiles, (Object)topLevelOtherFiles);
        Tuple2 tuple23 = tuple22;
        File[] topLevelSstFiles2 = (File[])tuple23._1();
        File[] topLevelOtherFiles2 = (File[])tuple23._2();
        return new Tuple2(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topLevelSstFiles2)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])archivedLogFiles)), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())), (Object)Predef$.MODULE$.wrapRefArray((Object[])topLevelOtherFiles2));
    }

    public static final /* synthetic */ long $anonfun$getLatestVersion$2(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toLong();
    }

    public static final /* synthetic */ long $anonfun$deleteOldVersions$2(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldVersions$8(Set versionsToDelete$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long v = tuple2._2$mcJ$sp();
        boolean bl = versionsToDelete$1.contains((Object)BoxesRunTime.boxToLong((long)v));
        return bl;
    }

    public static final /* synthetic */ void $anonfun$deleteOldVersions$10(RocksDBFileManager $this, IntRef failedToDelete$1, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            RocksDBImmutableFile file = (RocksDBImmutableFile)tuple2._1();
            long maxUsedVersion = tuple2._2$mcJ$sp();
            try {
                Path dfsFile = $this.dfsFilePath(file.dfsFileName());
                $this.fm().delete(dfsFile);
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Deleted file ").append(file).append(" that was last used in version ").append(maxUsedVersion).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                ++failedToDelete$1.elem;
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error deleting file ").append(file).append(", last used in version ").append(maxUsedVersion).toString(), e);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$loadImmutableFilesFromDfs$2(RocksDBFileManager $this, Map requiredFileNameToFileDetails$1, File existingFile) {
        block0: {
            boolean isSameFile = requiredFileNameToFileDetails$1.get((Object)existingFile.getName()).exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isSameFile(existingFile)));
            if (isSameFile) break block0;
            existingFile.delete();
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Deleted local file ").append(existingFile).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$loadImmutableFilesFromDfs$5(RocksDBFileManager $this, File localDir$1, LongRef filesCopied$2, LongRef bytesCopied$2, LongRef filesReused$2, RocksDBImmutableFile file) {
        String localFileName = file.localFileName();
        File localFile = $this.localFilePath(localDir$1, localFileName);
        if (!localFile.exists()) {
            Path dfsFile = $this.dfsFilePath(file.dfsFileName());
            $this.fs().copyToLocalFile(dfsFile, new Path(localFile.getAbsoluteFile().toURI()));
            long localFileSize = localFile.length();
            long expectedSize = file.sizeBytes();
            if (localFileSize != expectedSize) {
                throw new IllegalStateException(new StringBuilder(43).append("Copied ").append(dfsFile).append(" to ").append(localFile).append(",").append(" expected ").append(expectedSize).append(" bytes, found ").append(localFileSize).append(" bytes ").toString());
            }
            ++filesCopied$2.elem;
            bytesCopied$2.elem += localFileSize;
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Copied ").append(dfsFile).append(" to ").append(localFile).append(" - ").append(localFileSize).append(" bytes").toString());
        } else {
            ++filesReused$2.elem;
        }
    }

    private static final /* synthetic */ String filesStr$lzycompute$1(LazyRef filesStr$lzy$1, Path dfsZipFile$1, Seq files$1) {
        String string;
        LazyRef lazyRef = filesStr$lzy$1;
        synchronized (lazyRef) {
            string = filesStr$lzy$1.initialized() ? (String)filesStr$lzy$1.value() : (String)filesStr$lzy$1.initialize((Object)new StringBuilder(2).append(dfsZipFile$1).append("\n\t").append(files$1.mkString("\n\t")).toString());
        }
        return string;
    }

    private static final String filesStr$1(LazyRef filesStr$lzy$1, Path dfsZipFile$1, Seq files$1) {
        return filesStr$lzy$1.initialized() ? (String)filesStr$lzy$1.value() : RocksDBFileManager.filesStr$lzycompute$1(filesStr$lzy$1, dfsZipFile$1, files$1);
    }

    public static final /* synthetic */ void $anonfun$zipToDfsFile$1(ZipOutputStream zout$1, ObjectRef in$1, LongRef totalBytes$1, File file) {
        zout$1.putNextEntry(new ZipEntry(file.getName()));
        in$1.elem = new FileInputStream(file);
        int bytes = IOUtils.copy((InputStream)((InputStream)in$1.elem), (OutputStream)zout$1);
        ((InputStream)in$1.elem).close();
        zout$1.closeEntry();
        totalBytes$1.elem += (long)bytes;
    }

    private static final /* synthetic */ String[] files$lzycompute$1(LazyRef files$lzy$1, File dir$1) {
        String[] stringArray;
        LazyRef lazyRef = files$lzy$1;
        synchronized (lazyRef) {
            stringArray = files$lzy$1.initialized() ? (String[])files$lzy$1.value() : (String[])files$lzy$1.initialize(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)Utils$.MODULE$.recursiveList(dir$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))))).map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(9).append(f.getAbsolutePath()).append(" - ").append(f.length()).append(" bytes").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        }
        return stringArray;
    }

    private static final String[] files$2(LazyRef files$lzy$1, File dir$1) {
        return files$lzy$1.initialized() ? (String[])files$lzy$1.value() : RocksDBFileManager.files$lzycompute$1(files$lzy$1, dir$1);
    }

    public static final /* synthetic */ boolean $anonfun$listRocksDBFiles$1(File x$10) {
        return !x$10.isDirectory();
    }

    public RocksDBFileManager(String dfsRootDir, File localTempDir, Configuration hadoopConf, String loggingId) {
        this.dfsRootDir = dfsRootDir;
        this.localTempDir = localTempDir;
        this.hadoopConf = hadoopConf;
        this.loggingId = loggingId;
        Logging.$init$((Logging)this);
        this.versionToRocksDBFiles = new ConcurrentHashMap();
        this.fs = new Path(dfsRootDir).getFileSystem(hadoopConf);
        this.onlyZipFiles = new PathFilter(null){

            public boolean accept(Path path) {
                return path.toString().endsWith(".zip");
            }
        };
        this.loadCheckpointMetrics = RocksDBFileManagerMetrics$.MODULE$.EMPTY_METRICS();
        this.saveCheckpointMetrics = RocksDBFileManagerMetrics$.MODULE$.EMPTY_METRICS();
    }
}

