/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.optimizing.maintainer;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedTransferQueue;
import java.util.stream.Collectors;
import org.apache.amoro.IcebergFileEntry;
import org.apache.amoro.TableFormat;
import org.apache.amoro.config.DataExpirationConfig;
import org.apache.amoro.data.FileNameRules;
import org.apache.amoro.scan.TableEntriesScan;
import org.apache.amoro.server.optimizing.maintainer.IcebergTableMaintainer;
import org.apache.amoro.server.optimizing.maintainer.TableMaintainer;
import org.apache.amoro.server.table.TableConfigurations;
import org.apache.amoro.server.table.TableOrphanFilesCleaningMetrics;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.utils.HiveLocationUtil;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.collect.Iterables;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.shade.guava32.com.google.common.primitives.Longs;
import org.apache.amoro.table.BaseTable;
import org.apache.amoro.table.ChangeTable;
import org.apache.amoro.table.KeyedTable;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.amoro.utils.MixedTableUtil;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedTableMaintainer
implements TableMaintainer {
    private static final Logger LOG = LoggerFactory.getLogger(MixedTableMaintainer.class);
    private final MixedTable mixedTable;
    private ChangeTableMaintainer changeMaintainer;
    private final BaseTableMaintainer baseMaintainer;

    public MixedTableMaintainer(MixedTable mixedTable) {
        this.mixedTable = mixedTable;
        if (mixedTable.isKeyedTable()) {
            this.changeMaintainer = new ChangeTableMaintainer((UnkeyedTable)mixedTable.asKeyedTable().changeTable());
            this.baseMaintainer = new BaseTableMaintainer((UnkeyedTable)mixedTable.asKeyedTable().baseTable());
        } else {
            this.baseMaintainer = new BaseTableMaintainer(mixedTable.asUnkeyedTable());
        }
    }

    @Override
    public void cleanOrphanFiles(TableRuntime tableRuntime) {
        if (this.changeMaintainer != null) {
            this.changeMaintainer.cleanOrphanFiles(tableRuntime);
        }
        this.baseMaintainer.cleanOrphanFiles(tableRuntime);
    }

    @Override
    public void expireSnapshots(TableRuntime tableRuntime) {
        if (this.changeMaintainer != null) {
            this.changeMaintainer.expireSnapshots(tableRuntime);
        }
        this.baseMaintainer.expireSnapshots(tableRuntime);
    }

    @VisibleForTesting
    protected void expireSnapshots(long mustOlderThan, int minCount) {
        if (this.changeMaintainer != null) {
            this.changeMaintainer.expireSnapshots(mustOlderThan, minCount);
        }
        this.baseMaintainer.expireSnapshots(mustOlderThan, minCount);
    }

    @Override
    public void expireData(TableRuntime tableRuntime) {
        try {
            DataExpirationConfig expirationConfig = tableRuntime.getTableConfiguration().getExpiringDataConfig();
            Types.NestedField field = this.mixedTable.schema().findField(expirationConfig.getExpirationField());
            if (!TableConfigurations.isValidDataExpirationField(expirationConfig, field, this.mixedTable.name())) {
                return;
            }
            this.expireDataFrom(expirationConfig, this.expireMixedBaseOnRule(expirationConfig, field));
        }
        catch (Throwable t) {
            LOG.error("Unexpected purge error for table {} ", (Object)tableRuntime.getTableIdentifier(), (Object)t);
        }
    }

    protected Instant expireMixedBaseOnRule(DataExpirationConfig expirationConfig, Types.NestedField field) {
        Instant baseInstant;
        Instant changeInstant = Optional.ofNullable(this.changeMaintainer).isPresent() ? this.changeMaintainer.expireBaseOnRule(expirationConfig, field) : Instant.MIN;
        if (changeInstant.compareTo(baseInstant = this.baseMaintainer.expireBaseOnRule(expirationConfig, field)) >= 0) {
            return changeInstant;
        }
        return baseInstant;
    }

    @VisibleForTesting
    public void expireDataFrom(DataExpirationConfig expirationConfig, Instant instant) {
        if (instant.equals(Instant.MIN)) {
            return;
        }
        long expireTimestamp = instant.minusMillis(expirationConfig.getRetentionTime()).toEpochMilli();
        Types.NestedField field = this.mixedTable.schema().findField(expirationConfig.getExpirationField());
        LOG.info("Expiring data older than {} in mixed table {} ", (Object)Instant.ofEpochMilli(expireTimestamp).atZone(IcebergTableMaintainer.getDefaultZoneId(field)).toLocalDateTime(), (Object)this.mixedTable.name());
        Expression dataFilter = IcebergTableMaintainer.getDataExpression(this.mixedTable.schema(), expirationConfig, expireTimestamp);
        Pair<IcebergTableMaintainer.ExpireFiles, IcebergTableMaintainer.ExpireFiles> mixedExpiredFiles = this.mixedExpiredFileScan(expirationConfig, dataFilter, expireTimestamp);
        this.expireMixedFiles((IcebergTableMaintainer.ExpireFiles)mixedExpiredFiles.getLeft(), (IcebergTableMaintainer.ExpireFiles)mixedExpiredFiles.getRight(), expireTimestamp);
    }

    private Pair<IcebergTableMaintainer.ExpireFiles, IcebergTableMaintainer.ExpireFiles> mixedExpiredFileScan(DataExpirationConfig expirationConfig, Expression dataFilter, long expireTimestamp) {
        return this.mixedTable.isKeyedTable() ? this.keyedExpiredFileScan(expirationConfig, dataFilter, expireTimestamp) : Pair.of((Object)new IcebergTableMaintainer.ExpireFiles(), (Object)this.getBaseMaintainer().expiredFileScan(expirationConfig, dataFilter, expireTimestamp));
    }

    private Pair<IcebergTableMaintainer.ExpireFiles, IcebergTableMaintainer.ExpireFiles> keyedExpiredFileScan(DataExpirationConfig expirationConfig, Expression dataFilter, long expireTimestamp) {
        ConcurrentMap partitionFreshness = Maps.newConcurrentMap();
        KeyedTable keyedTable = this.mixedTable.asKeyedTable();
        ChangeTable changeTable = keyedTable.changeTable();
        BaseTable baseTable = keyedTable.baseTable();
        CloseableIterable changeEntries = CloseableIterable.transform(this.changeMaintainer.fileScan((Table)changeTable, dataFilter, expirationConfig, expireTimestamp), e -> new MixedFileEntry(e.getFile(), e.getTsBound(), true));
        CloseableIterable baseEntries = CloseableIterable.transform(this.baseMaintainer.fileScan((Table)baseTable, dataFilter, expirationConfig, expireTimestamp), e -> new MixedFileEntry(e.getFile(), e.getTsBound(), false));
        IcebergTableMaintainer.ExpireFiles changeExpiredFiles = new IcebergTableMaintainer.ExpireFiles();
        IcebergTableMaintainer.ExpireFiles baseExpiredFiles = new IcebergTableMaintainer.ExpireFiles();
        try (CloseableIterable entries = CloseableIterable.withNoopClose((Iterable)Iterables.concat((Iterable)changeEntries, (Iterable)baseEntries));){
            LinkedTransferQueue fileEntries = new LinkedTransferQueue();
            entries.forEach(e -> {
                if (IcebergTableMaintainer.mayExpired(e, partitionFreshness, expireTimestamp)) {
                    fileEntries.add(e);
                }
            });
            fileEntries.parallelStream().filter(e -> IcebergTableMaintainer.willNotRetain(e, expirationConfig, partitionFreshness)).forEach(e -> {
                if (e.isChange()) {
                    changeExpiredFiles.addFile((IcebergTableMaintainer.FileEntry)e);
                } else {
                    baseExpiredFiles.addFile((IcebergTableMaintainer.FileEntry)e);
                }
            });
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        return Pair.of((Object)changeExpiredFiles, (Object)baseExpiredFiles);
    }

    private void expireMixedFiles(IcebergTableMaintainer.ExpireFiles changeFiles, IcebergTableMaintainer.ExpireFiles baseFiles, long expireTimestamp) {
        Optional.ofNullable(this.changeMaintainer).ifPresent(c -> c.expireFiles(changeFiles, expireTimestamp));
        Optional.ofNullable(this.baseMaintainer).ifPresent(c -> c.expireFiles(baseFiles, expireTimestamp));
    }

    @Override
    public void autoCreateTags(TableRuntime tableRuntime) {
        throw new UnsupportedOperationException("Mixed table doesn't support auto create tags");
    }

    protected void cleanContentFiles(long lastTime, TableOrphanFilesCleaningMetrics orphanFilesCleaningMetrics) {
        if (this.changeMaintainer != null) {
            this.changeMaintainer.cleanContentFiles(lastTime, orphanFilesCleaningMetrics);
        }
        this.baseMaintainer.cleanContentFiles(lastTime, orphanFilesCleaningMetrics);
    }

    protected void cleanMetadata(long lastTime, TableOrphanFilesCleaningMetrics orphanFilesCleaningMetrics) {
        if (this.changeMaintainer != null) {
            this.changeMaintainer.cleanMetadata(lastTime, orphanFilesCleaningMetrics);
        }
        this.baseMaintainer.cleanMetadata(lastTime, orphanFilesCleaningMetrics);
    }

    protected void cleanDanglingDeleteFiles() {
        if (this.changeMaintainer != null) {
            this.changeMaintainer.cleanDanglingDeleteFiles();
        }
        this.baseMaintainer.cleanDanglingDeleteFiles();
    }

    public ChangeTableMaintainer getChangeMaintainer() {
        return this.changeMaintainer;
    }

    public BaseTableMaintainer getBaseMaintainer() {
        return this.baseMaintainer;
    }

    public static class MixedFileEntry
    extends IcebergTableMaintainer.FileEntry {
        private final boolean isChange;

        MixedFileEntry(ContentFile<?> file, Literal<Long> tsBound, boolean isChange) {
            super(file, tsBound);
            this.isChange = isChange;
        }

        public boolean isChange() {
            return this.isChange;
        }
    }

    public class BaseTableMaintainer
    extends IcebergTableMaintainer {
        private final Set<String> hiveFiles;

        public BaseTableMaintainer(UnkeyedTable unkeyedTable) {
            super((Table)unkeyedTable);
            this.hiveFiles = Sets.newHashSet();
            if (unkeyedTable.format() == TableFormat.MIXED_HIVE) {
                this.hiveFiles.addAll(HiveLocationUtil.getHiveLocation(MixedTableMaintainer.this.mixedTable));
            }
        }

        @Override
        public Set<String> orphanFileCleanNeedToExcludeFiles() {
            Set<String> baseFiles = super.orphanFileCleanNeedToExcludeFiles();
            return Sets.union(baseFiles, this.hiveFiles);
        }

        @Override
        protected Set<String> expireSnapshotNeedToExcludeFiles() {
            return this.hiveFiles;
        }

        @Override
        protected long mustOlderThan(TableRuntime tableRuntime, long now) {
            DataExpirationConfig expiringDataConfig = tableRuntime.getTableConfiguration().getExpiringDataConfig();
            long dataExpiringSnapshotTime = expiringDataConfig.isEnabled() && expiringDataConfig.getBaseOnRule() == DataExpirationConfig.BaseOnRule.LAST_COMMIT_TIME ? BaseTableMaintainer.fetchLatestNonOptimizedSnapshotTime(this.table) : Long.MAX_VALUE;
            return Longs.min((long[])new long[]{now - this.snapshotsKeepTime(tableRuntime), BaseTableMaintainer.fetchOptimizingPlanSnapshotTime(this.table, tableRuntime), dataExpiringSnapshotTime, BaseTableMaintainer.fetchLatestFlinkCommittedSnapshotTime(this.table), this.fetchLatestOptimizedSequenceSnapshotTime(this.table)});
        }

        private long fetchLatestOptimizedSequenceSnapshotTime(Table table) {
            if (MixedTableMaintainer.this.mixedTable.isKeyedTable()) {
                Snapshot snapshot = BaseTableMaintainer.findLatestSnapshotContainsKey(table, "optimized-sequence.exist");
                return snapshot == null ? Long.MAX_VALUE : snapshot.timestampMillis();
            }
            return Long.MAX_VALUE;
        }
    }

    public class ChangeTableMaintainer
    extends IcebergTableMaintainer {
        private static final int DATA_FILE_LIST_SPLIT = 3000;
        private final UnkeyedTable unkeyedTable;

        public ChangeTableMaintainer(UnkeyedTable unkeyedTable) {
            super((Table)unkeyedTable);
            this.unkeyedTable = unkeyedTable;
        }

        @Override
        @VisibleForTesting
        void expireSnapshots(long mustOlderThan, int minCount) {
            this.expireFiles(mustOlderThan);
            super.expireSnapshots(mustOlderThan, minCount);
        }

        @Override
        public void expireSnapshots(TableRuntime tableRuntime) {
            if (!this.expireSnapshotEnabled(tableRuntime)) {
                return;
            }
            long now = System.currentTimeMillis();
            this.expireFiles(now - this.snapshotsKeepTime(tableRuntime));
            this.expireSnapshots(this.mustOlderThan(tableRuntime, now), tableRuntime.getTableConfiguration().getSnapshotMinCount());
        }

        @Override
        protected long mustOlderThan(TableRuntime tableRuntime, long now) {
            return Longs.min((long[])new long[]{now - this.snapshotsKeepTime(tableRuntime), ChangeTableMaintainer.fetchLatestFlinkCommittedSnapshotTime(this.table)});
        }

        @Override
        protected long snapshotsKeepTime(TableRuntime tableRuntime) {
            return tableRuntime.getTableConfiguration().getChangeDataTTLMinutes() * 60L * 1000L;
        }

        public void expireFiles(long ttlPoint) {
            List<IcebergFileEntry> expiredDataFileEntries = this.getExpiredDataFileEntries(ttlPoint);
            this.deleteChangeFile(expiredDataFileEntries);
        }

        private List<IcebergFileEntry> getExpiredDataFileEntries(long ttlPoint) {
            TableEntriesScan entriesScan = TableEntriesScan.builder((Table)this.unkeyedTable).includeFileContent(new FileContent[]{FileContent.DATA}).build();
            ArrayList<IcebergFileEntry> changeTTLFileEntries = new ArrayList<IcebergFileEntry>();
            try (CloseableIterable entries = entriesScan.entries();){
                entries.forEach(entry -> {
                    Snapshot snapshot = this.unkeyedTable.snapshot(entry.getSnapshotId().longValue());
                    if (snapshot == null || snapshot.timestampMillis() < ttlPoint) {
                        changeTTLFileEntries.add((IcebergFileEntry)entry);
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close manifest entry scan of " + this.table.name(), e);
            }
            return changeTTLFileEntries;
        }

        private void deleteChangeFile(List<IcebergFileEntry> expiredDataFileEntries) {
            KeyedTable keyedTable = MixedTableMaintainer.this.mixedTable.asKeyedTable();
            if (CollectionUtils.isEmpty(expiredDataFileEntries)) {
                return;
            }
            StructLikeMap optimizedSequences = MixedTableUtil.readOptimizedSequence((KeyedTable)keyedTable);
            if (MapUtils.isEmpty((Map)optimizedSequences)) {
                LOG.info("table {} not contains max transaction id", (Object)keyedTable.id());
                return;
            }
            Map partitionDataFileMap = expiredDataFileEntries.stream().collect(Collectors.groupingBy(entry -> keyedTable.spec().partitionToPath(entry.getFile().partition()), Collectors.toList()));
            ArrayList<DataFile> changeDeleteFiles = new ArrayList<DataFile>();
            if (keyedTable.spec().isUnpartitioned()) {
                List partitionDataFiles = partitionDataFileMap.get(keyedTable.spec().partitionToPath(expiredDataFileEntries.get(0).getFile().partition()));
                Long optimizedSequence = (Long)optimizedSequences.get((Object)TablePropertyUtil.EMPTY_STRUCT);
                if (optimizedSequence != null && CollectionUtils.isNotEmpty(partitionDataFiles)) {
                    changeDeleteFiles.addAll(partitionDataFiles.stream().filter(entry -> FileNameRules.parseChangeTransactionId((String)entry.getFile().path().toString(), (long)entry.getSequenceNumber()) <= optimizedSequence).map(entry -> (DataFile)entry.getFile()).collect(Collectors.toList()));
                }
            } else {
                optimizedSequences.forEach((key, value) -> {
                    List partitionDataFiles = (List)partitionDataFileMap.get(keyedTable.spec().partitionToPath(key));
                    if (CollectionUtils.isNotEmpty((Collection)partitionDataFiles)) {
                        changeDeleteFiles.addAll(partitionDataFiles.stream().filter(entry -> FileNameRules.parseChangeTransactionId((String)entry.getFile().path().toString(), (long)entry.getSequenceNumber()) <= value).map(entry -> (DataFile)entry.getFile()).collect(Collectors.toList()));
                    }
                });
            }
            this.tryClearChangeFiles(changeDeleteFiles);
        }

        private void tryClearChangeFiles(List<DataFile> changeFiles) {
            if (CollectionUtils.isEmpty(changeFiles)) {
                return;
            }
            try {
                for (int startIndex = 0; startIndex < changeFiles.size(); startIndex += 3000) {
                    int end = Math.min(startIndex + 3000, changeFiles.size());
                    List<DataFile> tableFiles = changeFiles.subList(startIndex, end);
                    LOG.info("{} delete {} change files", (Object)this.unkeyedTable.name(), (Object)tableFiles.size());
                    if (!tableFiles.isEmpty()) {
                        DeleteFiles changeDelete = this.unkeyedTable.newDelete();
                        tableFiles.forEach(arg_0 -> ((DeleteFiles)changeDelete).deleteFile(arg_0));
                        changeDelete.commit();
                    }
                    LOG.info("{} change committed, delete {} files, complete {}/{}", new Object[]{this.unkeyedTable.name(), tableFiles.size(), end, changeFiles.size()});
                }
            }
            catch (Throwable t) {
                LOG.error("{} failed to delete change files, ignore", (Object)this.unkeyedTable.name(), (Object)t);
            }
        }
    }
}

