/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import net.sf.jsqlparser.expression.OracleHint;
import net.sf.jsqlparser.expression.WindowDefinition;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.Distinct;
import net.sf.jsqlparser.statement.select.First;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.KSQLWindow;
import net.sf.jsqlparser.statement.select.LateralView;
import net.sf.jsqlparser.statement.select.MySqlSqlCacheFlags;
import net.sf.jsqlparser.statement.select.OptimizeFor;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.Skip;
import net.sf.jsqlparser.statement.select.Top;
import net.sf.jsqlparser.statement.select.Wait;

public class PlainSelect
extends Select {
    private Distinct distinct = null;
    private List<SelectItem<?>> selectItems;
    private List<Table> intoTables;
    private FromItem fromItem;
    private List<LateralView> lateralViews;
    private List<Join> joins;
    private Expression where;
    private GroupByElement groupBy;
    private Expression having;
    private Expression qualify;
    private OptimizeFor optimizeFor;
    private Skip skip;
    private boolean mySqlHintStraightJoin;
    private First first;
    private Top top;
    private OracleHierarchicalExpression oracleHierarchical = null;
    private OracleHint oracleHint = null;
    private boolean forUpdate = false;
    private Table forUpdateTable = null;
    private boolean skipLocked;
    private Wait wait;
    private boolean mySqlSqlCalcFoundRows = false;
    private MySqlSqlCacheFlags mySqlCacheFlag = null;
    private String forXmlPath;
    private KSQLWindow ksqlWindow = null;
    private boolean noWait = false;
    private boolean emitChanges = false;
    private List<WindowDefinition> windowDefinitions;
    private boolean isUsingFinal = false;

    @Deprecated
    public boolean isUseBrackets() {
        return false;
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public List<Table> getIntoTables() {
        return this.intoTables;
    }

    public List<SelectItem<?>> getSelectItems() {
        return this.selectItems;
    }

    public SelectItem<?> getSelectItem(int index) {
        return this.selectItems.get(index);
    }

    public Expression getWhere() {
        return this.where;
    }

    public PlainSelect withFromItem(FromItem item) {
        this.setFromItem(item);
        return this;
    }

    public void setFromItem(FromItem item) {
        this.fromItem = item;
    }

    public void setIntoTables(List<Table> intoTables) {
        this.intoTables = intoTables;
    }

    public PlainSelect withSelectItems(List<SelectItem<?>> list) {
        this.setSelectItems(list);
        return this;
    }

    public void setSelectItems(List<SelectItem<?>> list) {
        this.selectItems = list;
    }

    public PlainSelect addSelectItems(SelectItem<?> ... items) {
        this.selectItems = Optional.ofNullable(this.selectItems).orElseGet(ArrayList::new);
        this.selectItems.addAll(Arrays.asList(items));
        return this;
    }

    public PlainSelect addSelectItems(Expression ... expressions) {
        this.selectItems = Optional.ofNullable(this.selectItems).orElseGet(ArrayList::new);
        for (Expression expression : expressions) {
            this.selectItems.add(SelectItem.from(expression));
        }
        return this;
    }

    public PlainSelect addSelectItem(Expression expression, Alias alias) {
        this.selectItems = Optional.ofNullable(this.selectItems).orElseGet(ArrayList::new);
        this.selectItems.add(new SelectItem<Expression>(expression, alias));
        return this;
    }

    public PlainSelect addSelectItem(Expression expression) {
        return this.addSelectItem(expression, null);
    }

    public void setWhere(Expression where) {
        this.where = where;
    }

    public List<LateralView> getLateralViews() {
        return this.lateralViews;
    }

    public void setLateralViews(Collection<LateralView> lateralViews) {
        if (this.lateralViews == null && lateralViews != null) {
            this.lateralViews = new ArrayList<LateralView>();
        } else {
            this.lateralViews.clear();
        }
        if (lateralViews != null) {
            this.lateralViews.addAll(lateralViews);
        } else {
            this.lateralViews = null;
        }
    }

    public PlainSelect addLateralView(LateralView lateralView) {
        if (this.lateralViews == null) {
            this.lateralViews = new ArrayList<LateralView>();
        }
        this.lateralViews.add(lateralView);
        return this;
    }

    public PlainSelect withLateralViews(Collection<LateralView> lateralViews) {
        this.setLateralViews(lateralViews);
        return this;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public Join getJoin(int index) {
        return this.joins.get(index);
    }

    public PlainSelect addJoins(Join ... joins) {
        List list = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        Collections.addAll(list, joins);
        return this.withJoins(list);
    }

    public PlainSelect withJoins(List<Join> joins) {
        this.setJoins(joins);
        return this;
    }

    public void setJoins(List<Join> list) {
        this.joins = list;
    }

    public boolean isUsingFinal() {
        return this.isUsingFinal;
    }

    public void setUsingFinal(boolean usingFinal) {
        this.isUsingFinal = usingFinal;
    }

    public PlainSelect withUsingFinal(boolean usingFinal) {
        this.setUsingFinal(usingFinal);
        return this;
    }

    @Override
    public void accept(SelectVisitor selectVisitor) {
        selectVisitor.visit(this);
    }

    public OptimizeFor getOptimizeFor() {
        return this.optimizeFor;
    }

    public void setOptimizeFor(OptimizeFor optimizeFor) {
        this.optimizeFor = optimizeFor;
    }

    public Top getTop() {
        return this.top;
    }

    public void setTop(Top top) {
        this.top = top;
    }

    public Skip getSkip() {
        return this.skip;
    }

    public void setSkip(Skip skip) {
        this.skip = skip;
    }

    public boolean getMySqlHintStraightJoin() {
        return this.mySqlHintStraightJoin;
    }

    public void setMySqlHintStraightJoin(boolean mySqlHintStraightJoin) {
        this.mySqlHintStraightJoin = mySqlHintStraightJoin;
    }

    public First getFirst() {
        return this.first;
    }

    public void setFirst(First first) {
        this.first = first;
    }

    public Distinct getDistinct() {
        return this.distinct;
    }

    public void setDistinct(Distinct distinct) {
        this.distinct = distinct;
    }

    public Expression getHaving() {
        return this.having;
    }

    public void setHaving(Expression expression) {
        this.having = expression;
    }

    public Expression getQualify() {
        return this.qualify;
    }

    public PlainSelect setQualify(Expression qualify) {
        this.qualify = qualify;
        return this;
    }

    public GroupByElement getGroupBy() {
        return this.groupBy;
    }

    public void setGroupByElement(GroupByElement groupBy) {
        this.groupBy = groupBy;
    }

    public PlainSelect addGroupByColumnReference(Expression expr) {
        this.groupBy = Optional.ofNullable(this.groupBy).orElseGet(GroupByElement::new);
        this.groupBy.addGroupByExpression(expr);
        return this;
    }

    public OracleHierarchicalExpression getOracleHierarchical() {
        return this.oracleHierarchical;
    }

    public void setOracleHierarchical(OracleHierarchicalExpression oracleHierarchical) {
        this.oracleHierarchical = oracleHierarchical;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public void setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
    }

    public Table getForUpdateTable() {
        return this.forUpdateTable;
    }

    public void setForUpdateTable(Table forUpdateTable) {
        this.forUpdateTable = forUpdateTable;
    }

    public OracleHint getOracleHint() {
        return this.oracleHint;
    }

    public void setOracleHint(OracleHint oracleHint) {
        this.oracleHint = oracleHint;
    }

    public void setWait(Wait wait) {
        this.wait = wait;
    }

    public Wait getWait() {
        return this.wait;
    }

    public String getForXmlPath() {
        return this.forXmlPath;
    }

    public void setForXmlPath(String forXmlPath) {
        this.forXmlPath = forXmlPath;
    }

    public KSQLWindow getKsqlWindow() {
        return this.ksqlWindow;
    }

    public void setKsqlWindow(KSQLWindow ksqlWindow) {
        this.ksqlWindow = ksqlWindow;
    }

    public void setEmitChanges(boolean emitChanges) {
        this.emitChanges = emitChanges;
    }

    public boolean isEmitChanges() {
        return this.emitChanges;
    }

    public List<WindowDefinition> getWindowDefinitions() {
        return this.windowDefinitions;
    }

    public void setWindowDefinitions(List<WindowDefinition> windowDefinitions) {
        this.windowDefinitions = windowDefinitions;
    }

    public boolean isSkipLocked() {
        return this.skipLocked;
    }

    public void setSkipLocked(boolean skipLocked) {
        this.skipLocked = skipLocked;
    }

    @Override
    public StringBuilder appendSelectBodyTo(StringBuilder builder) {
        builder.append("SELECT ");
        if (this.mySqlHintStraightJoin) {
            builder.append("STRAIGHT_JOIN ");
        }
        if (this.oracleHint != null) {
            builder.append(this.oracleHint).append(" ");
        }
        if (this.skip != null) {
            builder.append(this.skip).append(" ");
        }
        if (this.first != null) {
            builder.append(this.first).append(" ");
        }
        if (this.distinct != null) {
            builder.append(this.distinct).append(" ");
        }
        if (this.top != null) {
            builder.append(this.top).append(" ");
        }
        if (this.mySqlCacheFlag != null) {
            builder.append(this.mySqlCacheFlag.name()).append(" ");
        }
        if (this.mySqlSqlCalcFoundRows) {
            builder.append("SQL_CALC_FOUND_ROWS").append(" ");
        }
        builder.append(PlainSelect.getStringList(this.selectItems));
        if (this.intoTables != null) {
            builder.append(" INTO ");
            Iterator<Table> iter = this.intoTables.iterator();
            while (iter.hasNext()) {
                builder.append(iter.next().toString());
                if (!iter.hasNext()) continue;
                builder.append(", ");
            }
        }
        if (this.fromItem != null) {
            builder.append(" FROM ").append(this.fromItem);
            if (this.lateralViews != null) {
                for (LateralView lateralView : this.lateralViews) {
                    builder.append(" ").append(lateralView);
                }
            }
            if (this.joins != null) {
                for (Join join : this.joins) {
                    if (join.isSimple()) {
                        builder.append(", ").append(join);
                        continue;
                    }
                    builder.append(" ").append(join);
                }
            }
            if (this.isUsingFinal) {
                builder.append(" FINAL");
            }
            if (this.ksqlWindow != null) {
                builder.append(" WINDOW ").append(this.ksqlWindow);
            }
            if (this.where != null) {
                builder.append(" WHERE ").append(this.where);
            }
            if (this.oracleHierarchical != null) {
                builder.append(this.oracleHierarchical);
            }
            if (this.groupBy != null) {
                builder.append(" ").append(this.groupBy);
            }
            if (this.having != null) {
                builder.append(" HAVING ").append(this.having);
            }
            if (this.qualify != null) {
                builder.append(" QUALIFY ").append(this.qualify);
            }
            if (this.windowDefinitions != null) {
                builder.append(" WINDOW ");
                builder.append(this.windowDefinitions.stream().map(WindowDefinition::toString).collect(Collectors.joining(", ")));
            }
            if (this.emitChanges) {
                builder.append(" EMIT CHANGES");
            }
            if (this.isForUpdate()) {
                builder.append(" FOR UPDATE");
                if (this.forUpdateTable != null) {
                    builder.append(" OF ").append(this.forUpdateTable);
                }
                if (this.wait != null) {
                    builder.append(this.wait);
                }
                if (this.isNoWait()) {
                    builder.append(" NOWAIT");
                } else if (this.isSkipLocked()) {
                    builder.append(" SKIP LOCKED");
                }
            }
        } else if (this.where != null) {
            builder.append(" WHERE ").append(this.where);
        }
        return builder;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        super.appendTo(builder);
        if (this.optimizeFor != null) {
            builder.append(this.optimizeFor);
        }
        if (this.forXmlPath != null) {
            builder.append(" FOR XML PATH(").append(this.forXmlPath).append(")");
        }
        return builder.toString();
    }

    public PlainSelect withMySqlSqlCalcFoundRows(boolean mySqlCalcFoundRows) {
        this.setMySqlSqlCalcFoundRows(mySqlCalcFoundRows);
        return this;
    }

    public PlainSelect withMySqlSqlNoCache(MySqlSqlCacheFlags mySqlCacheFlag) {
        this.setMySqlSqlCacheFlag(mySqlCacheFlag);
        return this;
    }

    public void setMySqlSqlCalcFoundRows(boolean mySqlCalcFoundRows) {
        this.mySqlSqlCalcFoundRows = mySqlCalcFoundRows;
    }

    public void setMySqlSqlCacheFlag(MySqlSqlCacheFlags sqlCacheFlag) {
        this.mySqlCacheFlag = sqlCacheFlag;
    }

    public boolean getMySqlSqlCalcFoundRows() {
        return this.mySqlSqlCalcFoundRows;
    }

    public MySqlSqlCacheFlags getMySqlSqlCacheFlag() {
        return this.mySqlCacheFlag;
    }

    public void setNoWait(boolean noWait) {
        this.noWait = noWait;
    }

    public boolean isNoWait() {
        return this.noWait;
    }

    public PlainSelect withDistinct(Distinct distinct) {
        this.setDistinct(distinct);
        return this;
    }

    public PlainSelect withIntoTables(List<Table> intoTables) {
        this.setIntoTables(intoTables);
        return this;
    }

    public PlainSelect withWhere(Expression where) {
        this.setWhere(where);
        return this;
    }

    public PlainSelect withOptimizeFor(OptimizeFor optimizeFor) {
        this.setOptimizeFor(optimizeFor);
        return this;
    }

    public PlainSelect withSkip(Skip skip) {
        this.setSkip(skip);
        return this;
    }

    public PlainSelect withMySqlHintStraightJoin(boolean mySqlHintStraightJoin) {
        this.setMySqlHintStraightJoin(mySqlHintStraightJoin);
        return this;
    }

    public PlainSelect withFirst(First first) {
        this.setFirst(first);
        return this;
    }

    public PlainSelect withTop(Top top) {
        this.setTop(top);
        return this;
    }

    public PlainSelect withOracleHierarchical(OracleHierarchicalExpression oracleHierarchical) {
        this.setOracleHierarchical(oracleHierarchical);
        return this;
    }

    public PlainSelect withOracleHint(OracleHint oracleHint) {
        this.setOracleHint(oracleHint);
        return this;
    }

    @Override
    public PlainSelect withOracleSiblings(boolean oracleSiblings) {
        this.setOracleSiblings(oracleSiblings);
        return this;
    }

    public PlainSelect withForUpdate(boolean forUpdate) {
        this.setForUpdate(forUpdate);
        return this;
    }

    public PlainSelect withForUpdateTable(Table forUpdateTable) {
        this.setForUpdateTable(forUpdateTable);
        return this;
    }

    public PlainSelect withForXmlPath(String forXmlPath) {
        this.setForXmlPath(forXmlPath);
        return this;
    }

    public PlainSelect withKsqlWindow(KSQLWindow ksqlWindow) {
        this.setKsqlWindow(ksqlWindow);
        return this;
    }

    public PlainSelect withNoWait(boolean noWait) {
        this.setNoWait(noWait);
        return this;
    }

    public PlainSelect withSkipLocked(boolean skipLocked) {
        this.setSkipLocked(skipLocked);
        return this;
    }

    public PlainSelect withHaving(Expression having) {
        this.setHaving(having);
        return this;
    }

    public PlainSelect withWait(Wait wait) {
        this.setWait(wait);
        return this;
    }

    public PlainSelect addSelectItems(Collection<? extends SelectItem<?>> selectItems) {
        List collection = Optional.ofNullable(this.getSelectItems()).orElseGet(ArrayList::new);
        collection.addAll(selectItems);
        return this.withSelectItems(collection);
    }

    public PlainSelect addIntoTables(Table ... intoTables) {
        List collection = Optional.ofNullable(this.getIntoTables()).orElseGet(ArrayList::new);
        Collections.addAll(collection, intoTables);
        return this.withIntoTables(collection);
    }

    public PlainSelect addIntoTables(Collection<? extends Table> intoTables) {
        List collection = Optional.ofNullable(this.getIntoTables()).orElseGet(ArrayList::new);
        collection.addAll(intoTables);
        return this.withIntoTables(collection);
    }

    public PlainSelect addJoins(Collection<? extends Join> joins) {
        List collection = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        collection.addAll(joins);
        return this.withJoins(collection);
    }

    public <E extends FromItem> E getFromItem(Class<E> type) {
        return (E)((FromItem)type.cast(this.getFromItem()));
    }

    public <E extends Expression> E getWhere(Class<E> type) {
        return (E)((Expression)type.cast(this.getWhere()));
    }

    public <E extends Expression> E getHaving(Class<E> type) {
        return (E)((Expression)type.cast(this.getHaving()));
    }
}

