/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.source;

import org.apache.fluss.row.Decimal;
import org.apache.fluss.row.InternalRow;
import org.apache.fluss.row.TimestampLtz;
import org.apache.fluss.row.TimestampNtz;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.variant.Variant;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;

public class FlussRowAsPaimonRow
implements org.apache.paimon.data.InternalRow {
    protected InternalRow internalRow;
    protected final RowType tableRowType;

    public FlussRowAsPaimonRow(RowType tableTowType) {
        this.tableRowType = tableTowType;
    }

    public FlussRowAsPaimonRow(InternalRow internalRow, RowType tableTowType) {
        this.internalRow = internalRow;
        this.tableRowType = tableTowType;
    }

    @Override
    public int getFieldCount() {
        return this.internalRow.getFieldCount();
    }

    @Override
    public RowKind getRowKind() {
        return RowKind.INSERT;
    }

    @Override
    public void setRowKind(RowKind rowKind) {
    }

    @Override
    public boolean isNullAt(int pos) {
        return this.internalRow.isNullAt(pos);
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.internalRow.getBoolean(pos);
    }

    @Override
    public byte getByte(int pos) {
        return this.internalRow.getByte(pos);
    }

    @Override
    public short getShort(int pos) {
        return this.internalRow.getShort(pos);
    }

    @Override
    public int getInt(int pos) {
        return this.internalRow.getInt(pos);
    }

    @Override
    public long getLong(int pos) {
        return this.internalRow.getLong(pos);
    }

    @Override
    public float getFloat(int pos) {
        return this.internalRow.getFloat(pos);
    }

    @Override
    public double getDouble(int pos) {
        return this.internalRow.getDouble(pos);
    }

    @Override
    public BinaryString getString(int pos) {
        return BinaryString.fromBytes(this.internalRow.getString(pos).toBytes());
    }

    @Override
    public org.apache.paimon.data.Decimal getDecimal(int pos, int precision, int scale) {
        Decimal flussDecimal = this.internalRow.getDecimal(pos, precision, scale);
        if (flussDecimal.isCompact()) {
            return org.apache.paimon.data.Decimal.fromUnscaledLong(flussDecimal.toUnscaledLong(), precision, scale);
        }
        return org.apache.paimon.data.Decimal.fromBigDecimal(flussDecimal.toBigDecimal(), precision, scale);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        DataType paimonTimestampType = this.tableRowType.getTypeAt(pos);
        switch (paimonTimestampType.getTypeRoot()) {
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                if (TimestampNtz.isCompact((int)precision)) {
                    return Timestamp.fromEpochMillis(this.internalRow.getTimestampNtz(pos, precision).getMillisecond());
                }
                TimestampNtz timestampNtz = this.internalRow.getTimestampNtz(pos, precision);
                return Timestamp.fromEpochMillis(timestampNtz.getMillisecond(), timestampNtz.getNanoOfMillisecond());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                if (TimestampLtz.isCompact((int)precision)) {
                    return Timestamp.fromEpochMillis(this.internalRow.getTimestampLtz(pos, precision).getEpochMillisecond());
                }
                TimestampLtz timestampLtz = this.internalRow.getTimestampLtz(pos, precision);
                return Timestamp.fromEpochMillis(timestampLtz.getEpochMillisecond(), timestampLtz.getNanoOfMillisecond());
            }
        }
        throw new UnsupportedOperationException("Unsupported data type to get timestamp: " + String.valueOf(paimonTimestampType));
    }

    @Override
    public byte[] getBinary(int pos) {
        return this.internalRow.getBytes(pos);
    }

    @Override
    public Variant getVariant(int i) {
        throw new UnsupportedOperationException("getVariant is not support for Fluss record currently.");
    }

    @Override
    public InternalArray getArray(int pos) {
        throw new UnsupportedOperationException("getArray is not support for Fluss record currently.");
    }

    @Override
    public InternalMap getMap(int pos) {
        throw new UnsupportedOperationException("getMap is not support for Fluss record currently.");
    }

    @Override
    public org.apache.paimon.data.InternalRow getRow(int pos, int pos1) {
        throw new UnsupportedOperationException("getRow is not support for Fluss record currently.");
    }
}

