/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.variant.Variant;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.Preconditions;

@Public
public final class GenericRow
implements InternalRow,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object[] fields;
    private RowKind kind;

    public GenericRow(RowKind kind, int arity) {
        this.fields = new Object[arity];
        this.kind = kind;
    }

    public GenericRow(int arity) {
        this.fields = new Object[arity];
        this.kind = RowKind.INSERT;
    }

    public void setField(int pos, Object value) {
        this.fields[pos] = value;
    }

    public Object getField(int pos) {
        return this.fields[pos];
    }

    @Override
    public int getFieldCount() {
        return this.fields.length;
    }

    @Override
    public RowKind getRowKind() {
        return this.kind;
    }

    @Override
    public void setRowKind(RowKind kind) {
        Preconditions.checkNotNull(kind);
        this.kind = kind;
    }

    @Override
    public boolean isNullAt(int pos) {
        return this.fields[pos] == null;
    }

    @Override
    public boolean getBoolean(int pos) {
        return (Boolean)this.fields[pos];
    }

    @Override
    public byte getByte(int pos) {
        return (Byte)this.fields[pos];
    }

    @Override
    public short getShort(int pos) {
        return (Short)this.fields[pos];
    }

    @Override
    public int getInt(int pos) {
        return (Integer)this.fields[pos];
    }

    @Override
    public long getLong(int pos) {
        return (Long)this.fields[pos];
    }

    @Override
    public float getFloat(int pos) {
        return ((Float)this.fields[pos]).floatValue();
    }

    @Override
    public double getDouble(int pos) {
        return (Double)this.fields[pos];
    }

    @Override
    public BinaryString getString(int pos) {
        return (BinaryString)this.fields[pos];
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        return (Decimal)this.fields[pos];
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        return (Timestamp)this.fields[pos];
    }

    @Override
    public byte[] getBinary(int pos) {
        return (byte[])this.fields[pos];
    }

    @Override
    public Variant getVariant(int pos) {
        return (Variant)this.fields[pos];
    }

    @Override
    public InternalArray getArray(int pos) {
        return (InternalArray)this.fields[pos];
    }

    @Override
    public InternalMap getMap(int pos) {
        return (InternalMap)this.fields[pos];
    }

    @Override
    public InternalRow getRow(int pos, int numFields) {
        return (InternalRow)this.fields[pos];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenericRow)) {
            return false;
        }
        GenericRow that = (GenericRow)o;
        return this.kind == that.kind && Arrays.deepEquals(this.fields, that.fields);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.kind});
        result = 31 * result + Arrays.deepHashCode(this.fields);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.kind.shortString()).append("(");
        for (int i = 0; i < this.fields.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(GenericRow.arrayAwareToString(this.fields[i]));
        }
        sb.append(")");
        return sb.toString();
    }

    private static String arrayAwareToString(Object o) {
        String arrayString = Arrays.deepToString(new Object[]{o});
        return arrayString.substring(1, arrayString.length() - 1);
    }

    public static GenericRow of(Object ... values2) {
        GenericRow row = new GenericRow(values2.length);
        for (int i = 0; i < values2.length; ++i) {
            row.setField(i, values2[i]);
        }
        return row;
    }

    public static GenericRow ofKind(RowKind kind, Object ... values2) {
        GenericRow row = new GenericRow(kind, values2.length);
        for (int i = 0; i < values2.length; ++i) {
            row.setField(i, values2[i]);
        }
        return row;
    }
}

