/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.utils.Pair;

@Public
public class BucketEntry {
    private final BinaryRow partition;
    private final int bucket;
    private final long recordCount;
    private final long fileSizeInBytes;
    private final long fileCount;
    private final long lastFileCreationTime;

    public BucketEntry(BinaryRow partition, int bucket, long recordCount, long fileSizeInBytes, long fileCount, long lastFileCreationTime) {
        this.partition = partition;
        this.bucket = bucket;
        this.recordCount = recordCount;
        this.fileSizeInBytes = fileSizeInBytes;
        this.fileCount = fileCount;
        this.lastFileCreationTime = lastFileCreationTime;
    }

    public BinaryRow partition() {
        return this.partition;
    }

    public int bucket() {
        return this.bucket;
    }

    public long recordCount() {
        return this.recordCount;
    }

    public long fileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    public long fileCount() {
        return this.fileCount;
    }

    public long lastFileCreationTime() {
        return this.lastFileCreationTime;
    }

    public BucketEntry merge(BucketEntry entry) {
        return new BucketEntry(this.partition, this.bucket, this.recordCount + entry.recordCount, this.fileSizeInBytes + entry.fileSizeInBytes, this.fileCount + entry.fileCount, Math.max(this.lastFileCreationTime, entry.lastFileCreationTime));
    }

    public static BucketEntry fromManifestEntry(ManifestEntry entry) {
        PartitionEntry partitionEntry = PartitionEntry.fromManifestEntry(entry);
        return new BucketEntry(partitionEntry.partition(), entry.bucket(), partitionEntry.recordCount(), partitionEntry.fileSizeInBytes(), partitionEntry.fileCount(), partitionEntry.lastFileCreationTime());
    }

    public static Collection<BucketEntry> merge(Collection<ManifestEntry> fileEntries) {
        HashMap<Pair, BucketEntry> buckets = new HashMap<Pair, BucketEntry>();
        for (ManifestEntry entry : fileEntries) {
            BucketEntry bucketEntry = BucketEntry.fromManifestEntry(entry);
            buckets.compute(Pair.of(entry.partition(), entry.bucket()), (part, old) -> old == null ? bucketEntry : old.merge(bucketEntry));
        }
        return buckets.values();
    }

    public static void merge(Collection<BucketEntry> from, Map<Pair<BinaryRow, Integer>, BucketEntry> to) {
        for (BucketEntry entry : from) {
            to.compute(Pair.of(entry.partition(), entry.bucket), (part, old) -> old == null ? entry : old.merge(entry));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketEntry that = (BucketEntry)o;
        return this.recordCount == that.recordCount && this.fileSizeInBytes == that.fileSizeInBytes && this.fileCount == that.fileCount && this.lastFileCreationTime == that.lastFileCreationTime && this.bucket == that.bucket && Objects.equals(this.partition, that.partition);
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.bucket, this.recordCount, this.fileSizeInBytes, this.fileCount, this.lastFileCreationTime);
    }
}

