/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.provider;

import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import nl.altindag.ssl.SSLFactory;

public final class SSLFactoryProvider {
    private static SSLFactoryProvider INSTANCE;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private SSLFactory sslFactory;

    private SSLFactoryProvider() {
    }

    public static void set(SSLFactory sslFactory) {
        SSLFactoryProvider instance = SSLFactoryProvider.getInstance();
        instance.writeLock.lock();
        try {
            instance.sslFactory = sslFactory;
        }
        finally {
            instance.writeLock.unlock();
        }
    }

    public static Optional<SSLFactory> get() {
        SSLFactoryProvider instance = SSLFactoryProvider.getInstance();
        instance.readLock.lock();
        try {
            Optional<SSLFactory> optional = Optional.ofNullable(instance.sslFactory);
            return optional;
        }
        finally {
            instance.readLock.unlock();
        }
    }

    private static SSLFactoryProvider getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SSLFactoryProvider();
        }
        return INSTANCE;
    }
}

