/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.exts.concurrent;

import java.io.Serializable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000514A!\u0004\b\u0001/!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003)\u0011\u0015y\u0003\u0001\"\u00011\u0011\u001d)\u0004A1A\u0005\u0002YBaA\u000f\u0001!\u0002\u00139\u0004bB\u001e\u0001\u0005\u0004%\t\u0001\u0010\u0005\u0007\u0007\u0002\u0001\u000b\u0011B\u001f\t\u000b\u0011\u0003A\u0011A#\t\u000b\u0011\u0003A\u0011I)\t\u000b]\u0003A\u0011\t-\t\u000b%\u0004A\u0011\t6\t\u000b-\u0004A\u0011\t6\u00035\tcwnY6j]\u001e$\u0006N]3bIB{w\u000e\\#yK\u000e,Ho\u001c:\u000b\u0005=\u0001\u0012AC2p]\u000e,(O]3oi*\u0011\u0011CE\u0001\u0005Kb$8O\u0003\u0002\u0014)\u0005A1o[:b[V,GNC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0001$\t\t\u00033}i\u0011A\u0007\u0006\u0003\u001fmQ!\u0001H\u000f\u0002\tU$\u0018\u000e\u001c\u0006\u0002=\u0005!!.\u0019<b\u0013\t\u0001#D\u0001\nUQJ,\u0017\r\u001a)p_2,\u00050Z2vi>\u0014\bC\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u001e\u0003\u0011a\u0017M\\4\n\u0005\u0019\u001a#!D!vi>\u001cEn\\:fC\ndW-\u0001\u0005q_>d7+\u001b>f!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\rIe\u000e^\u0001\ncV,W/Z*ju\u0016\fa\u0001P5oSRtDcA\u00194iA\u0011!\u0007A\u0007\u0002\u001d!)qe\u0001a\u0001Q!)af\u0001a\u0001Q\u0005I1/Z7ba\"|'/Z\u000b\u0002oA\u0011\u0011\u0004O\u0005\u0003si\u0011\u0011bU3nCBDwN]3\u0002\u0015M,W.\u00199i_J,\u0007%A\u0004sk:t\u0017N\\4\u0016\u0003u\u0002\"AP!\u000e\u0003}R!\u0001\u0011\u000e\u0002\r\u0005$x.\\5d\u0013\t\u0011uHA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\teVtg.\u001b8hA\u00059Q\r_3dkR,GC\u0001$J!\tIs)\u0003\u0002IU\t!QK\\5u\u0011\u0019Q\u0005\u0002\"a\u0001\u0017\u0006!A/Y:l!\rICJT\u0005\u0003\u001b*\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0003S=K!\u0001\u0015\u0016\u0003\u0007\u0005s\u0017\u0010\u0006\u0002G%\")1+\u0003a\u0001)\u0006A!/\u001e8oC\ndW\r\u0005\u0002#+&\u0011ak\t\u0002\t%Vtg.\u00192mK\u0006a\u0011M\u001a;fe\u0016CXmY;uKR\u0019a)W.\t\u000biS\u0001\u0019\u0001+\u0002\u0003IDQ\u0001\u0018\u0006A\u0002u\u000b\u0011\u0001\u001e\t\u0003=\u001at!a\u00183\u000f\u0005\u0001\u001cW\"A1\u000b\u0005\t4\u0012A\u0002\u001fs_>$h(C\u0001,\u0013\t)'&A\u0004qC\u000e\\\u0017mZ3\n\u0005\u001dD'!\u0003+ie><\u0018M\u00197f\u0015\t)'&A\u0003dY>\u001cX\rF\u0001G\u0003!\u0019\b.\u001e;e_^t\u0007")
public class BlockingThreadPoolExecutor
extends ThreadPoolExecutor
implements AutoCloseable {
    private final Semaphore semaphore;
    private final AtomicBoolean running;

    public Semaphore semaphore() {
        return this.semaphore;
    }

    public AtomicBoolean running() {
        return this.running;
    }

    public void execute(Function0<Object> task) {
        this.execute(new Runnable(null, task){
            private final Function0 task$1;

            public void run() {
                this.task$1.apply();
            }
            {
                this.task$1 = task$1;
            }
        });
    }

    @Override
    public void execute(Runnable runnable) {
        Predef$.MODULE$.require(this.running().get(), (Function0 & Serializable)() -> "This executor has shutdown, cannot accept anymore tasks");
        boolean acquired = false;
        while (!acquired) {
            try {
                this.semaphore().acquire();
                acquired = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            super.execute(runnable);
        }
        catch (RejectedExecutionException e) {
            this.semaphore().release();
            throw e;
        }
    }

    @Override
    public void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        this.semaphore().release();
    }

    @Override
    public void close() {
        this.shutdown();
    }

    @Override
    public void shutdown() {
        this.running().set(false);
        super.shutdown();
    }

    public BlockingThreadPoolExecutor(int poolSize, int queueSize) {
        super(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.semaphore = new Semaphore(poolSize + queueSize);
        this.running = new AtomicBoolean(true);
    }
}

