/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Content;

public interface Literal {
    public long size() throws IOException;

    public InputStream getInputStream() throws IOException;

    default public Optional<byte[][]> asBytesSequence() {
        return Optional.empty();
    }

    default public Content asMailboxContent() {
        final Literal literal = this;
        return new Content(){

            public InputStream getInputStream() throws IOException {
                return literal.getInputStream();
            }

            public long size() throws MailboxException {
                try {
                    return literal.size();
                }
                catch (IOException e) {
                    throw new MailboxException("Error computing content size", (Throwable)e);
                }
            }
        };
    }
}

