/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.postgres.upload;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.apache.james.backends.postgres.quota.PostgresQuotaCurrentValueDAO;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaComponent;
import org.apache.james.core.quota.QuotaCurrentValue;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.core.quota.QuotaType;
import org.apache.james.jmap.api.upload.UploadUsageRepository;
import reactor.core.publisher.Mono;

public class PostgresUploadUsageRepository
implements UploadUsageRepository {
    private static final QuotaSizeUsage DEFAULT_QUOTA_SIZE_USAGE = QuotaSizeUsage.size((long)0L);
    private final PostgresQuotaCurrentValueDAO quotaCurrentValueDAO;

    @Inject
    @Singleton
    public PostgresUploadUsageRepository(PostgresQuotaCurrentValueDAO quotaCurrentValueDAO) {
        this.quotaCurrentValueDAO = quotaCurrentValueDAO;
    }

    public Mono<Void> increaseSpace(Username username, QuotaSizeUsage usage) {
        return this.quotaCurrentValueDAO.increase(QuotaCurrentValue.Key.of((QuotaComponent)QuotaComponent.JMAP_UPLOADS, (String)username.asString(), (QuotaType)QuotaType.SIZE), usage.asLong());
    }

    public Mono<Void> decreaseSpace(Username username, QuotaSizeUsage usage) {
        return this.quotaCurrentValueDAO.decrease(QuotaCurrentValue.Key.of((QuotaComponent)QuotaComponent.JMAP_UPLOADS, (String)username.asString(), (QuotaType)QuotaType.SIZE), usage.asLong());
    }

    public Mono<QuotaSizeUsage> getSpaceUsage(Username username) {
        return this.quotaCurrentValueDAO.getQuotaCurrentValue(QuotaCurrentValue.Key.of((QuotaComponent)QuotaComponent.JMAP_UPLOADS, (String)username.asString(), (QuotaType)QuotaType.SIZE)).map(quotaCurrentValue -> QuotaSizeUsage.size((long)quotaCurrentValue.getCurrentValue())).defaultIfEmpty((Object)DEFAULT_QUOTA_SIZE_USAGE);
    }

    public Mono<Void> resetSpace(Username username, QuotaSizeUsage newUsage) {
        return this.quotaCurrentValueDAO.upsert(QuotaCurrentValue.Key.of((QuotaComponent)QuotaComponent.JMAP_UPLOADS, (String)username.asString(), (QuotaType)QuotaType.SIZE), newUsage.asLong()).then();
    }
}

