/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Set;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.mailbox.events.GenericGroup;
import org.apache.james.modules.mailbox.ListenerConfiguration;
import org.apache.james.modules.mailbox.ListenersConfiguration;
import org.apache.james.modules.mailbox.MailboxListenerFactory;
import org.apache.james.modules.mailbox.MailboxListenersLoader;
import org.apache.james.utils.ClassName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailboxListenersLoaderImpl
implements Configurable,
MailboxListenersLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailboxListenersLoaderImpl.class);
    private final MailboxListenerFactory mailboxListenerFactory;
    private final EventBus eventBus;
    private final Set<EventListener.ReactiveGroupEventListener> guiceDefinedListeners;

    @Inject
    MailboxListenersLoaderImpl(MailboxListenerFactory mailboxListenerFactory, EventBus eventBus, Set<EventListener.ReactiveGroupEventListener> guiceDefinedListeners, Set<EventListener.GroupEventListener> nonReactiveGuiceDefinedListeners) {
        this.mailboxListenerFactory = mailboxListenerFactory;
        this.eventBus = eventBus;
        this.guiceDefinedListeners = ImmutableSet.builder().addAll(guiceDefinedListeners).addAll(this.wrap(nonReactiveGuiceDefinedListeners)).build();
    }

    private ImmutableSet<EventListener.ReactiveGroupEventListener> wrap(Set<EventListener.GroupEventListener> nonReactiveGuiceDefinedListeners) {
        return (ImmutableSet)nonReactiveGuiceDefinedListeners.stream().map(EventListener::wrapReactive).collect(ImmutableSet.toImmutableSet());
    }

    public void configure(HierarchicalConfiguration<ImmutableNode> configuration) {
        this.configure(ListenersConfiguration.from(configuration));
    }

    public void configure(ListenersConfiguration listenersConfiguration) {
        LOGGER.info("Loading user registered mailbox listeners");
        if (listenersConfiguration.isGroupListenerConsumptionEnabled()) {
            this.guiceDefinedListeners.forEach(arg_0 -> ((EventBus)this.eventBus).register(arg_0));
            listenersConfiguration.getListenersConfiguration().stream().map(this::createListener).forEach(this::register);
        }
    }

    @Override
    public void register(Pair<Group, EventListener.ReactiveEventListener> listener) {
        this.eventBus.register((EventListener.ReactiveEventListener)listener.getRight(), (Group)listener.getLeft());
    }

    @Override
    public Pair<Group, EventListener.ReactiveEventListener> createListener(ListenerConfiguration configuration) {
        ClassName listenerClass = new ClassName(configuration.getClazz());
        try {
            LOGGER.info("Loading user registered mailbox listener {}", (Object)listenerClass);
            EventListener mailboxListener = this.mailboxListenerFactory.newInstance().withConfiguration(configuration.getConfiguration()).withExecutionMode(configuration.isAsync().map(this::getExecutionMode)).clazz(listenerClass).build();
            return configuration.getGroup().map(GenericGroup::new).map(group -> Pair.of((Object)group, (Object)this.wrapIfNeeded(mailboxListener))).orElseGet(() -> this.withDefaultGroup(mailboxListener));
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Error while loading user registered global listener {}", (Object)listenerClass, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private EventListener.ReactiveEventListener wrapIfNeeded(EventListener listener) {
        if (listener instanceof EventListener.ReactiveEventListener) {
            return (EventListener.ReactiveGroupEventListener)listener;
        }
        return EventListener.wrapReactive((EventListener)listener);
    }

    private Pair<Group, EventListener.ReactiveEventListener> withDefaultGroup(EventListener mailboxListener) {
        Preconditions.checkArgument((boolean)(mailboxListener instanceof EventListener.GroupEventListener));
        EventListener.GroupEventListener groupMailboxListener = (EventListener.GroupEventListener)mailboxListener;
        return Pair.of((Object)groupMailboxListener.getDefaultGroup(), (Object)this.wrapIfNeeded((EventListener)groupMailboxListener));
    }

    private EventListener.ExecutionMode getExecutionMode(boolean isAsync) {
        if (isAsync) {
            return EventListener.ExecutionMode.ASYNCHRONOUS;
        }
        return EventListener.ExecutionMode.SYNCHRONOUS;
    }
}

