/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.resource;

import jakarta.inject.Inject;
import java.util.Optional;
import java.util.Set;
import org.apache.james.DefaultUserEntityValidator;
import org.apache.james.RecipientRewriteTableUserEntityValidator;
import org.apache.james.UserEntityValidator;
import org.apache.james.core.Username;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.user.api.UsersRepository;

public class SpringUserEntityValidator
implements UserEntityValidator {
    private UsersRepository usersRepository;
    private RecipientRewriteTable rrt;
    private UserEntityValidator delegate;

    @Inject
    public void setUsersRepository(UsersRepository usersRepository) {
        this.usersRepository = usersRepository;
        if (this.rrt != null) {
            this.delegate = UserEntityValidator.aggregate((UserEntityValidator[])new UserEntityValidator[]{new DefaultUserEntityValidator(usersRepository), new RecipientRewriteTableUserEntityValidator(this.rrt)});
        }
    }

    @Inject
    public void setRrt(RecipientRewriteTable rrt) {
        this.rrt = rrt;
        if (this.usersRepository != null) {
            this.delegate = UserEntityValidator.aggregate((UserEntityValidator[])new UserEntityValidator[]{new DefaultUserEntityValidator(this.usersRepository), new RecipientRewriteTableUserEntityValidator(rrt)});
        }
    }

    public Optional<UserEntityValidator.ValidationFailure> canCreate(Username username, Set<UserEntityValidator.EntityType> ignoredTypes) throws Exception {
        return this.delegate.canCreate(username, ignoredTypes);
    }
}

