/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SimplePagedResultsControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String PAGED_RESULTS_OID = "1.2.840.113556.1.4.319";
    @NotNull
    private static final String JSON_FIELD_COOKIE = "cookie";
    @NotNull
    private static final String JSON_FIELD_SIZE = "size";
    private static final long serialVersionUID = 2186787148024999291L;
    @NotNull
    private final ASN1OctetString cookie;
    private final int size;

    SimplePagedResultsControl() {
        this.size = 0;
        this.cookie = new ASN1OctetString();
    }

    public SimplePagedResultsControl(int pageSize) {
        super(PAGED_RESULTS_OID, false, SimplePagedResultsControl.encodeValue(pageSize, null));
        this.size = pageSize;
        this.cookie = new ASN1OctetString();
    }

    public SimplePagedResultsControl(int pageSize, boolean isCritical) {
        super(PAGED_RESULTS_OID, isCritical, SimplePagedResultsControl.encodeValue(pageSize, null));
        this.size = pageSize;
        this.cookie = new ASN1OctetString();
    }

    public SimplePagedResultsControl(int pageSize, @Nullable ASN1OctetString cookie) {
        super(PAGED_RESULTS_OID, false, SimplePagedResultsControl.encodeValue(pageSize, cookie));
        this.size = pageSize;
        this.cookie = cookie == null ? new ASN1OctetString() : cookie;
    }

    public SimplePagedResultsControl(int pageSize, @Nullable ASN1OctetString cookie, boolean isCritical) {
        super(PAGED_RESULTS_OID, isCritical, SimplePagedResultsControl.encodeValue(pageSize, cookie));
        this.size = pageSize;
        this.cookie = cookie == null ? new ASN1OctetString() : cookie;
    }

    public SimplePagedResultsControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        ASN1Sequence valueSequence;
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PAGED_RESULTS_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            valueSequence = ASN1Sequence.decodeAsSequence(valueElement);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PAGED_RESULTS_VALUE_NOT_SEQUENCE.get(ae), ae);
        }
        ASN1Element[] valueElements = valueSequence.elements();
        if (valueElements.length != 2) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PAGED_RESULTS_INVALID_ELEMENT_COUNT.get(valueElements.length));
        }
        try {
            this.size = ASN1Integer.decodeAsInteger(valueElements[0]).intValue();
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PAGED_RESULTS_FIRST_NOT_INTEGER.get(ae), ae);
        }
        this.cookie = ASN1OctetString.decodeAsOctetString(valueElements[1]);
    }

    @Override
    @NotNull
    public SimplePagedResultsControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new SimplePagedResultsControl(oid, isCritical, value);
    }

    @Nullable
    public static SimplePagedResultsControl get(@NotNull SearchResult result) throws LDAPException {
        Control c = result.getResponseControl(PAGED_RESULTS_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof SimplePagedResultsControl) {
            return (SimplePagedResultsControl)c;
        }
        return new SimplePagedResultsControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @NotNull
    private static ASN1OctetString encodeValue(int pageSize, @Nullable ASN1OctetString cookie) {
        ASN1Element[] valueElements = cookie == null ? new ASN1Element[]{new ASN1Integer(pageSize), new ASN1OctetString()} : new ASN1Element[]{new ASN1Integer(pageSize), cookie};
        return new ASN1OctetString(new ASN1Sequence(valueElements).encode());
    }

    public int getSize() {
        return this.size;
    }

    @NotNull
    public ASN1OctetString getCookie() {
        return this.cookie;
    }

    public boolean moreResultsToReturn() {
        return this.cookie.getValue().length > 0;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_PAGED_RESULTS.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        valueFields.put(JSON_FIELD_SIZE, new JSONNumber(this.size));
        byte[] cookieBytes = this.cookie.getValue();
        if (cookieBytes.length > 0) {
            valueFields.put(JSON_FIELD_COOKIE, new JSONString(Base64.encode(cookieBytes)));
        }
        return new JSONObject(new JSONField("oid", PAGED_RESULTS_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_PAGED_RESULTS.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    public static SimplePagedResultsControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        ASN1OctetString cookie;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new SimplePagedResultsControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        JSONObject valueObject = jsonControl.getValueObject();
        Integer pageSize = valueObject.getFieldAsInteger(JSON_FIELD_SIZE);
        if (pageSize == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PAGED_RESULTS_JSON_MISSING_PAGE_SIZE.get(controlObject.toSingleLineString(), JSON_FIELD_SIZE));
        }
        String cookieBase64 = valueObject.getFieldAsString(JSON_FIELD_COOKIE);
        if (cookieBase64 == null || cookieBase64.isEmpty()) {
            cookie = new ASN1OctetString();
        } else {
            try {
                cookie = new ASN1OctetString(Base64.decode(cookieBase64));
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PAGED_RESULTS_JSON_COOKIE_NOT_BASE64.get(controlObject.toSingleLineString(), JSON_FIELD_COOKIE), e);
            }
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_SIZE, JSON_FIELD_COOKIE)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PAGED_RESULTS_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new SimplePagedResultsControl(pageSize, cookie, jsonControl.getCriticality());
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("SimplePagedResultsControl(pageSize=");
        buffer.append(this.size);
        buffer.append(", isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

