/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.common;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.common.BaseEnhNodeFactoryImpl;
import org.apache.jena.ontapi.common.EnhNodeFactory;
import org.apache.jena.ontapi.common.EnhNodeFilter;
import org.apache.jena.ontapi.common.EnhNodeFinder;
import org.apache.jena.ontapi.common.OntEnhNodeFactories;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.util.iterator.ExtendedIterator;

public class CompositeEnhNodeFactoryImpl
extends BaseEnhNodeFactoryImpl {
    private final List<EnhNodeFactory> factories;
    private final EnhNodeFinder finder;
    private final EnhNodeFilter fittingFilter;

    public CompositeEnhNodeFactoryImpl(EnhNodeFinder finder, EnhNodeFilter fittingFilter, EnhNodeFactory ... factories) {
        this.finder = finder;
        this.fittingFilter = fittingFilter;
        if (factories.length == 0) {
            throw new IllegalArgumentException("Empty factory array");
        }
        this.factories = CompositeEnhNodeFactoryImpl.unbend(factories);
    }

    private static List<EnhNodeFactory> unbend(EnhNodeFactory ... factories) {
        return Arrays.stream(factories).flatMap(f -> f instanceof CompositeEnhNodeFactoryImpl ? ((CompositeEnhNodeFactoryImpl)f).factories.stream() : Stream.of(f)).collect(Collectors.toList());
    }

    @Override
    public EnhNode wrap(Node node, EnhGraph eg) {
        EnhNode res = this.createInstance(node, eg);
        if (res != null) {
            return res;
        }
        throw new OntJenaException.Conversion(String.format("Can't wrap node %s. Use direct factory.", OntEnhNodeFactories.toPrintString(node, eg)));
    }

    @Override
    public boolean canWrap(Node node, EnhGraph eg) {
        return (this.fittingFilter == null || this.fittingFilter.test(node, eg)) && Iterators.anyMatch(this.listFactories(), f -> f.canWrap(node, eg));
    }

    @Override
    public EnhNode createInstance(Node node, EnhGraph eg) {
        if (this.fittingFilter != null && !this.fittingFilter.test(node, eg)) {
            return null;
        }
        return Iterators.findFirst(Iterators.filter(this.listFactories(), f -> f.canWrap(node, eg)).mapWith(f -> f.createInstance(node, eg))).orElse(null);
    }

    @Override
    public ExtendedIterator<EnhNode> iterator(EnhGraph eg) {
        if (this.finder != null) {
            return this.finder.iterator(eg).mapWith(n -> this.createInstance((Node)n, eg)).filterDrop(Objects::isNull);
        }
        return Iterators.distinct(Iterators.flatMap(this.listFactories(), f -> f.iterator(eg)));
    }

    public EnhNodeFinder getFinder() {
        return this.finder;
    }

    public EnhNodeFilter getFilter() {
        return this.fittingFilter;
    }

    public ExtendedIterator<? extends EnhNodeFactory> listFactories() {
        return Iterators.create(this.factories);
    }
}

