/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdArgModule;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.cmd.ModBase;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.NotFoundException;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;

public class ModAssembler
extends ModBase {
    public static final ArgDecl assemblerDescDecl = new ArgDecl(true, "desc", "dataset");
    private String assemblerFile = null;
    Object thingDescribed = null;

    public ModAssembler() {
        AssemblerUtils.init();
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        if (cmdLine.contains(assemblerDescDecl)) {
            this.assemblerFile = cmdLine.getValue(assemblerDescDecl);
        }
    }

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.add(assemblerDescDecl, "--desc=", "Assembler description file");
    }

    public String getAssemblerFile() {
        return this.assemblerFile;
    }

    public Object create(Resource type) {
        Object thing = null;
        try {
            thing = AssemblerUtils.build(this.assemblerFile, type);
        }
        catch (ARQException ex) {
            throw ex;
        }
        catch (NotFoundException ex) {
            throw new CmdException("Not found: " + ex.getMessage());
        }
        catch (JenaException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CmdException("Error creating", ex);
        }
        return thing;
    }
}

